/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.productvariant;

import java.lang.reflect.Constructor;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.faktorips.runtime.IClRepositoryObject;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductVariantRuntimeHelper {
    protected static final String ATTRIBUTE_NAME_VARIED_PRODUCT_CMPT = "variedProductCmpt";
    protected static final String ATTRIBUTE_NAME_RUNTIME_ID = "runtimeID";

    public void initProductComponentVariation(ProductComponent originalProductComponent, ProductComponent productComponentToBeInitialized, Element prodCmptElement) {
        this.loadAndVary(originalProductComponent, prodCmptElement, productComponentToBeInitialized);
    }

    public IProductComponentGeneration initProductComponentGenerationVariation(IRuntimeRepository runtimeRepository, GenerationTocEntry tocEntry, Element genElement) {
        GregorianCalendar validFrom = tocEntry.getValidFrom().toGregorianCalendar(TimeZone.getDefault());
        ProductComponent originalCmpt = this.getOriginalProdCmpt(runtimeRepository, genElement);
        ProductComponent variedCmpt = (ProductComponent)runtimeRepository.getProductComponent(tocEntry.getParent().getIpsObjectId());
        ProductComponentGeneration originalGeneration = (ProductComponentGeneration)originalCmpt.getGenerationBase(validFrom);
        ProductComponentGeneration variedProductCmptGeneration = this.createNewInstance(originalGeneration, variedCmpt);
        this.loadAndVary(originalGeneration, genElement, variedProductCmptGeneration);
        return variedProductCmptGeneration;
    }

    protected ProductComponentGeneration createNewInstance(ProductComponentGeneration generationTemplate, ProductComponent parentProductCmpt) {
        try {
            Constructor<?> constructor = generationTemplate.getClass().getConstructor(parentProductCmpt.getClass());
            return (ProductComponentGeneration)constructor.newInstance(parentProductCmpt);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of class \"" + this.getClass().getName() + "\" (ProductComponent: \"" + parentProductCmpt.getId() + "\" validfrom " + String.valueOf(generationTemplate.getValidFrom(TimeZone.getDefault())) + ")", e);
        }
    }

    protected void loadAndVary(IXmlPersistenceSupport originalObject, Element variationXML, IClRepositoryObject objectToInitialize) {
        Document document = (Document)variationXML.getOwnerDocument().cloneNode(false);
        Element originalElement = originalObject.toXml(document);
        originalElement.removeAttribute("validFrom");
        objectToInitialize.initFromXml(originalElement);
        objectToInitialize.initFromXml(variationXML);
    }

    public ProductComponent getOriginalProdCmpt(IRuntimeRepository runtimeRepository, Element element) {
        String originalRuntimeID = element.getAttribute(ATTRIBUTE_NAME_VARIED_PRODUCT_CMPT);
        return (ProductComponent)runtimeRepository.getProductComponent(originalRuntimeID);
    }

    public boolean isProductVariantXML(Element productVariantElement) {
        return productVariantElement.hasAttribute(ATTRIBUTE_NAME_VARIED_PRODUCT_CMPT);
    }
}

