/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.faktorips.runtime.internal.tableindex.MergeAndCopyStructure;
import org.faktorips.runtime.internal.tableindex.SearchStructure;

public class ResultStructure<R>
extends SearchStructure<R>
implements MergeAndCopyStructure<ResultStructure<R>> {
    private final Set<R> resultSet;

    ResultStructure() {
        this.resultSet = new HashSet<R>();
    }

    ResultStructure(R result) {
        this();
        this.resultSet.add(result);
    }

    ResultStructure(Set<R> result) {
        this.resultSet = new HashSet<R>(result);
    }

    public static <R> ResultStructure<R> createWith(R resultValue) {
        return new ResultStructure<R>(resultValue);
    }

    public static <R> ResultStructure<R> createWith(Set<R> resultValues) {
        return new ResultStructure<R>(resultValues);
    }

    @Override
    public SearchStructure<R> get(Object key) {
        return this;
    }

    @Override
    public Set<R> get() {
        return Collections.unmodifiableSet(this.resultSet);
    }

    @Override
    public void merge(ResultStructure<R> otherStructure) {
        this.resultSet.addAll(otherStructure.resultSet);
    }

    public int hashCode() {
        return Objects.hash(this.resultSet);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResultStructure other = (ResultStructure)obj;
        return Objects.equals(this.resultSet, other.resultSet);
    }

    public String toString() {
        return "ResultStructure [resultSet=" + String.valueOf(this.resultSet) + "]";
    }

    @Override
    public ResultStructure<R> copy() {
        return new ResultStructure<R>(this.resultSet);
    }
}

