/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsFormula;
import org.faktorips.runtime.model.annotation.IpsFormulas;
import org.faktorips.runtime.model.type.Formula;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.AnnotationProcessor;
import org.faktorips.runtime.model.type.read.PartDescriptor;
import org.faktorips.runtime.model.type.read.TypePartCollector;

public class FormulaCollector
extends TypePartCollector<Formula, FormulaDescriptor> {
    public FormulaCollector() {
        super(Arrays.asList(new FormulaProcessor()));
    }

    @Override
    protected FormulaDescriptor createDescriptor() {
        return new FormulaDescriptor();
    }

    @Override
    protected String[] getNames(AnnotatedDeclaration annotatedDeclaration) {
        if (annotatedDeclaration.is(IpsFormulas.class)) {
            return annotatedDeclaration.get(IpsFormulas.class).value();
        }
        return NO_NAMES;
    }

    static class FormulaProcessor
    extends AnnotationProcessor<IpsFormula, FormulaDescriptor> {
        public FormulaProcessor() {
            super(IpsFormula.class);
        }

        @Override
        public String getName(IpsFormula annotation) {
            return annotation.name();
        }

        @Override
        public void process(FormulaDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            descriptor.setAnnotatedElement((Method)annotatedElement);
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
        }
    }

    protected static class FormulaDescriptor
    extends PartDescriptor<Formula> {
        private boolean changingOverTime;
        private Method annotatedElement;

        protected FormulaDescriptor() {
        }

        public boolean isValid() {
            return this.getAnnotatedElement() != null;
        }

        public Method getAnnotatedElement() {
            return this.annotatedElement;
        }

        public void setAnnotatedElement(Method annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }

        @Override
        public Formula create(ModelElement parentElement) {
            Type type = (Type)parentElement;
            if (this.isValid()) {
                return this.createValid(type);
            }
            throw new IllegalArgumentException(String.valueOf(type.getDeclarationClass()) + " lists \"" + this.getName() + "\" as one of it's @IpsFormulas but no matching @IpsFormula could be found.");
        }

        private Formula createValid(Type type) {
            return new Formula(type, this.getAnnotatedElement(), this.changingOverTime);
        }
    }
}

