/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.Objects;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.w3c.dom.Element;

public abstract class TocEntryObject
extends TocEntry {
    public static final String PROPERTY_ENTRYTYPE = "entryType";
    public static final String PROPERTY_IPS_OBJECT_ID = "ipsObjectId";
    public static final String PROPERTY_IPS_OBJECT_QNAME = "ipsObjectQualifiedName";
    private String ipsObjectId;
    private String ipsObjectQualifiedName;

    protected TocEntryObject(String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
        super(implementationClassName, xmlResourceName);
        this.ipsObjectId = ipsObjectId;
        this.ipsObjectQualifiedName = ipsObjectQualifiedName;
    }

    public String getIpsObjectId() {
        return this.ipsObjectId;
    }

    public String getIpsObjectQualifiedName() {
        return this.ipsObjectQualifiedName;
    }

    @Override
    protected void addToXml(Element entryElement) {
        super.addToXml(entryElement);
        entryElement.setAttribute(PROPERTY_IPS_OBJECT_ID, this.ipsObjectId);
        entryElement.setAttribute(PROPERTY_IPS_OBJECT_QNAME, this.ipsObjectQualifiedName);
    }

    public String toString() {
        return "TocEntry(%s:%s)".formatted(this.getXmlElementTag(), this.ipsObjectId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ipsObjectId == null ? 0 : this.ipsObjectId.hashCode());
        return 31 * result + (this.ipsObjectQualifiedName == null ? 0 : this.ipsObjectQualifiedName.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        TocEntryObject other;
        block5: {
            block4: {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof TocEntryObject)) break block4;
                other = (TocEntryObject)obj;
                if (super.equals(obj)) break block5;
            }
            return false;
        }
        return Objects.equals(this.ipsObjectId, other.ipsObjectId) && Objects.equals(this.ipsObjectQualifiedName, other.ipsObjectQualifiedName) && super.equals(obj);
    }

    String getPackageName() {
        String qualifiedName = this.getIpsObjectQualifiedName();
        int index = qualifiedName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qualifiedName.substring(0, index);
    }

    String getUnqualifiedName() {
        String qualifiedName = this.getIpsObjectQualifiedName();
        int index = qualifiedName.lastIndexOf(".");
        if (index == -1) {
            return qualifiedName;
        }
        if (index == qualifiedName.length() - 1) {
            return "";
        }
        return qualifiedName.substring(index + 1);
    }
}

