/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.type.ModelElement;

public class Deprecation {
    private final String sinceVersionString;
    private final boolean forRemoval;

    public Deprecation(String sinceVersionString, boolean forRemoval) {
        this.sinceVersionString = IpsStringUtils.isBlank(sinceVersionString) ? null : sinceVersionString;
        this.forRemoval = forRemoval;
    }

    public Optional<String> getSinceVersion() {
        return Optional.ofNullable(this.sinceVersionString);
    }

    public boolean isMarkedForRemoval() {
        return this.forRemoval;
    }

    public static Optional<Deprecation> of(AnnotatedDeclaration annotatedDeclaration) {
        Deprecated deprecated = annotatedDeclaration.get(Deprecated.class);
        return Deprecation.of(deprecated);
    }

    public static Optional<Deprecation> of(Method method) {
        Deprecated deprecated = method.getAnnotation(Deprecated.class);
        return Deprecation.of(deprecated);
    }

    public static Optional<Deprecation> of(Field field) {
        Deprecated deprecated = field.getAnnotation(Deprecated.class);
        return Deprecation.of(deprecated);
    }

    private static Optional<Deprecation> of(Deprecated deprecated) {
        if (deprecated != null) {
            String sinceVersionString = null;
            boolean forRemoval = false;
            try {
                Method sinceMethod = deprecated.getClass().getDeclaredMethod("since", new Class[0]);
                sinceVersionString = (String)ModelElement.invokeMethod(sinceMethod, deprecated, new Object[0]);
                Method forRemovalMethod = deprecated.getClass().getDeclaredMethod("forRemoval", new Class[0]);
                forRemoval = (Boolean)ModelElement.invokeMethod(forRemovalMethod, deprecated, new Object[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            return Optional.of(new Deprecation(sinceVersionString, forRemoval));
        }
        return Optional.empty();
    }
}

