/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.LinkedHashMap;
import java.util.Map;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.DescriptionXmlHelper;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.values.InternationalString;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class FormulaHandler {
    private Object callerObject;
    private final IRuntimeRepository repository;
    private IFormulaEvaluator formulaEvaluator;
    private Map<String, String> availableFormulas = new LinkedHashMap<String, String>();
    private Map<String, InternationalString> formulaDescriptions = new LinkedHashMap<String, InternationalString>();

    public FormulaHandler(Object callerObject, IRuntimeRepository repository) {
        this.callerObject = callerObject;
        this.repository = repository;
    }

    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    public void doInitFormulaFromXml(Element element) {
        this.availableFormulas.putAll(ProductComponentXmlUtil.getAvailableFormulars(element));
        this.initDescriptions(element);
        if (this.getFormulaEvaluator() != null) {
            return;
        }
        if (this.getRepository() != null) {
            IFormulaEvaluatorFactory factory = this.getRepository().getFormulaEvaluatorFactory();
            boolean hasFormulas = this.availableFormulas.values().stream().anyMatch(IpsStringUtils::isNotBlank);
            if (factory != null && hasFormulas) {
                Map<String, String> expressions = this.getCompiledExpressionsFromFormulas(element);
                this.formulaEvaluator = factory.createFormulaEvaluator(this.callerObject, expressions);
            }
        }
    }

    private void initDescriptions(Element element) {
        NodeList formulaNodes = element.getElementsByTagName("Formula");
        for (int i = 0; i < formulaNodes.getLength(); ++i) {
            Element formulaElement = (Element)formulaNodes.item(i);
            InternationalString description = DescriptionXmlHelper.read(formulaElement);
            this.setDescription(formulaElement.getAttribute("formulaSignature"), description);
        }
    }

    protected Map<String, String> getCompiledExpressionsFromFormulas(Element element) {
        LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
        NodeList formulas = element.getElementsByTagName("Formula");
        for (int i = 0; i < formulas.getLength(); ++i) {
            Element aFormula = (Element)formulas.item(i);
            String name = aFormula.getAttribute("formulaSignature");
            NodeList nodeList = aFormula.getElementsByTagName("compiledExpression");
            if (nodeList.getLength() != 1) {
                throw new RuntimeException("Expression for Formula: " + name + " not found");
            }
            Element expression = (Element)nodeList.item(0);
            String formulaExpression = expression.getTextContent();
            expressions.put(name, formulaExpression);
        }
        return expressions;
    }

    public boolean isFormulaAvailable(String formularSignature) {
        String expression = this.availableFormulas.get(formularSignature);
        return IpsStringUtils.isNotBlank(expression);
    }

    public void writeFormulaToXml(Element element) {
        this.addFormulasToElement(element, this.formulaEvaluator, this.availableFormulas);
    }

    protected void addFormulasToElement(Element element, IFormulaEvaluator formulaEvaluator, Map<String, String> availableFormulars) {
        if (availableFormulars != null) {
            for (Map.Entry<String, String> expressionEntry : availableFormulars.entrySet()) {
                Element formula = element.getOwnerDocument().createElement("Formula");
                formula.setAttribute("formulaSignature", expressionEntry.getKey());
                ValueToXmlHelper.addValueToElement(expressionEntry.getValue(), formula, "Expression");
                DescriptionXmlHelper.write(this.getDescription(expressionEntry.getKey()), formula);
                if (formulaEvaluator != null) {
                    String compiledExpression = formulaEvaluator.getNameToExpressionMap().get(expressionEntry.getKey());
                    ValueToXmlHelper.addCDataValueToElement(compiledExpression, formula, "compiledExpression");
                }
                element.appendChild(formula);
            }
        }
    }

    String getFormula(String formulaSignature) {
        return this.availableFormulas.get(formulaSignature);
    }

    void setFormula(String formulaSignature, String formulaText) {
        this.availableFormulas.put(formulaSignature, formulaText);
    }

    @CheckForNull
    InternationalString getDescription(String formulaSignature) {
        return this.formulaDescriptions.get(formulaSignature);
    }

    void setDescription(String formulaSignature, @CheckForNull InternationalString description) {
        this.formulaDescriptions.put(formulaSignature, description);
    }
}

