/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.util.Arrays;
import java.util.Optional;
import org.faktorips.annotation.UtilityClass;

@UtilityClass
public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static <R> Optional<R> findStaticFieldValue(Class<?> clazz, String fieldName) {
        return ReflectionHelper.findFieldValue(clazz, fieldName, null);
    }

    public static <T, R> Optional<R> findFieldValue(Class<T> clazz, String fieldName, T object) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> fieldName.equals(f.getName())).findFirst().map(f -> {
            try {
                f.setAccessible(true);
                return f.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

