/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.IDatabaseLengthValidationConfiguration;
import org.faktorips.runtime.validation.NumericConstraint;
import org.faktorips.runtime.validation.StringLengthConstraint;
import org.faktorips.values.Decimal;

public class DefaultDatabaseLengthValidationConfiguration
implements IDatabaseLengthValidationConfiguration {
    public static final String MSGCODE_STRING_TOO_LONG = "STRING_TOO_LONG";
    public static final String MSGKEY_STRING_TOO_LONG = "InvalidAttribute.StringTooLong";
    public static final String MSGCODE_NUMBER_EXCEEDS_PRECISION = "NUMBER_EXCEEDS_PRECISION";
    public static final String MSGKEY_NUMBER_EXCEEDS_PRECISION = "InvalidAttribute.NumberExceedsPrecision";
    public static final String MSGCODE_NUMBER_EXCEEDS_SCALE = "NUMBER_EXCEEDS_SCALE";
    public static final String MSGKEY_NUMBER_EXCEEDS_SCALE = "InvalidAttribute.NumberExceedsScale";
    public static final String RESOURCE_BUNDLE_NAME = DefaultDatabaseLengthValidationConfiguration.class.getName();
    private final Locale locale;
    private final ResourceBundle resourceBundle;
    private final Map<Class<? extends Number>, NumericConstraint> numericConstraints = new HashMap<Class<? extends Number>, NumericConstraint>();
    private IMarker technicalConstraintViolationMarker;
    private StringLengthConstraint stringLengthConstraint;
    private BiPredicate<PolicyAttribute, IModelObject> shouldValidate;

    public DefaultDatabaseLengthValidationConfiguration(Locale locale, ResourceBundle resourceBundle) {
        this.locale = locale;
        this.resourceBundle = resourceBundle;
    }

    public DefaultDatabaseLengthValidationConfiguration(Locale locale) {
        this(locale, ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale));
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    protected ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public DefaultDatabaseLengthValidationConfiguration withTechnicalConstraintViolationMarker(IMarker technicalConstraintViolationMarker) {
        this.technicalConstraintViolationMarker = technicalConstraintViolationMarker;
        return this;
    }

    @Override
    public IMarker getTechnicalConstraintViolationMarker() {
        return this.technicalConstraintViolationMarker;
    }

    public DefaultDatabaseLengthValidationConfiguration withStringLengthConstraint(StringLengthConstraint stringLengthConstraint) {
        this.stringLengthConstraint = stringLengthConstraint;
        return this;
    }

    public DefaultDatabaseLengthValidationConfiguration withStringLengthConstraint(Charset stringEncoding, int maxStringByteLength) {
        return this.withStringLengthConstraint(new StringLengthConstraint(stringEncoding, maxStringByteLength));
    }

    public DefaultDatabaseLengthValidationConfiguration withStringLengthConstraint(int maxStringByteLength) {
        return this.withStringLengthConstraint(new StringLengthConstraint(StandardCharsets.UTF_8, maxStringByteLength));
    }

    @Override
    public StringLengthConstraint getStringLengthConstraint() {
        return this.stringLengthConstraint;
    }

    public DefaultDatabaseLengthValidationConfiguration withNumericConstraint(Class<? extends Number> numericDatatype, NumericConstraint numericConstraint) {
        this.numericConstraints.put(numericDatatype, numericConstraint);
        return this;
    }

    public DefaultDatabaseLengthValidationConfiguration withNumericConstraint(Class<? extends Number> numericDatatype, int precision, int scale) {
        return this.withNumericConstraint(numericDatatype, new NumericConstraint(precision, scale));
    }

    public DefaultDatabaseLengthValidationConfiguration withNumericConstraint(Class<? extends Number> numericDatatype, int precision) {
        return this.withNumericConstraint(numericDatatype, new NumericConstraint(precision));
    }

    public DefaultDatabaseLengthValidationConfiguration withNumericConstraintForAllNumbers(int precision, int scale) {
        NumericConstraint numericConstraint = new NumericConstraint(precision, scale);
        return this.withNumericConstraint(Decimal.class, numericConstraint).withNumericConstraint(BigDecimal.class, numericConstraint).withNumericConstraint(Float.class, numericConstraint).withNumericConstraint(Double.class, numericConstraint).withNumericConstraint(Short.class, numericConstraint).withNumericConstraint(Integer.class, numericConstraint).withNumericConstraint(Long.class, numericConstraint);
    }

    @Override
    public NumericConstraint getNumericConstraint(Class<? extends Number> numericDatatype) {
        return this.numericConstraints.get(numericDatatype);
    }

    @Override
    public boolean shouldValidate(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return this.shouldValidate == null || this.shouldValidate.test(policyAttribute, modelObject);
    }

    public DefaultDatabaseLengthValidationConfiguration withAttributeFilter(BiPredicate<PolicyAttribute, IModelObject> shouldValidate) {
        this.shouldValidate = shouldValidate;
        return this;
    }

    @Override
    public Message createMessageForStringLengthViolation(PolicyAttribute attribute, IModelObject modelObject, int actualLength, int lengthLimit) {
        return this.createMessage(MSGKEY_STRING_TOO_LONG, MSGCODE_STRING_TOO_LONG, modelObject, attribute, actualLength, lengthLimit);
    }

    @Override
    public Message createMessageForPrecisionViolation(PolicyAttribute attribute, IModelObject modelObject, Class<? extends Number> numericDatatype, int actualPrecision, int precisionLimit) {
        return this.createMessage(MSGKEY_NUMBER_EXCEEDS_PRECISION, MSGCODE_NUMBER_EXCEEDS_PRECISION, modelObject, attribute, actualPrecision, precisionLimit);
    }

    @Override
    public Message createMessageForScaleViolation(PolicyAttribute attribute, IModelObject modelObject, Class<? extends Number> numericDatatype, int actualScale, int scaleLimit) {
        return this.createMessage(MSGKEY_NUMBER_EXCEEDS_SCALE, MSGCODE_NUMBER_EXCEEDS_SCALE, modelObject, attribute, actualScale, scaleLimit);
    }

    protected Message createMessage(String msgKey, String msgCode, IModelObject modelObject, PolicyAttribute attribute, int actualValue, int maxValue) {
        String msgText = String.format(this.getResourceBundle().getString(msgKey), attribute.getLabel(this.getLocale()), actualValue, maxValue);
        Message.Builder messageBuilder = Message.error(msgText).code(msgCode).invalidObjectWithProperties(modelObject, attribute.getName());
        this.addMarker(messageBuilder);
        return messageBuilder.create();
    }

    protected void addMarker(Message.Builder messageBuilder) {
        if (this.getTechnicalConstraintViolationMarker() != null) {
            messageBuilder.markers(this.getTechnicalConstraintViolationMarker());
        }
    }
}

