/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IVisitorSupport;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.validation.IDatabaseLengthValidationConfiguration;
import org.faktorips.runtime.validation.NumericConstraint;
import org.faktorips.runtime.validation.StringLengthConstraint;
import org.faktorips.values.Decimal;

public final class DatabaseLengthValidation {
    private final IDatabaseLengthValidationConfiguration config;

    private DatabaseLengthValidation(IDatabaseLengthValidationConfiguration config) {
        this.config = config;
    }

    public static DatabaseLengthValidation with(IDatabaseLengthValidationConfiguration config) {
        return new DatabaseLengthValidation(config);
    }

    public MessageList validateWithChildren(IModelObject modelObject) {
        MessageList messages = new MessageList();
        IVisitorSupport.orGenericVisitorSupport(modelObject).accept(o -> {
            messages.add(this.validateOnly(o));
            return true;
        });
        return messages;
    }

    public MessageList validateOnly(IModelObject modelObject) {
        MessageList messages = new MessageList();
        PolicyCmptType policyType = IpsModel.getPolicyCmptType(modelObject.getClass());
        if (policyType != null) {
            for (PolicyAttribute attribute : policyType.getAttributes()) {
                if (!this.config.shouldValidate(attribute, modelObject)) continue;
                this.validateAttribute(attribute, modelObject, messages);
            }
        }
        return messages;
    }

    private void validateAttribute(PolicyAttribute attribute, IModelObject modelObject, MessageList messages) {
        TypeDescriptor.OfField<Class<?>> datatype = attribute.getDatatype();
        if (datatype.isPrimitive()) {
            datatype = MethodType.methodType(datatype).wrap().returnType();
        }
        if (String.class.isAssignableFrom((Class<?>)datatype)) {
            this.validateString((String)attribute.getValue(modelObject), attribute, modelObject, messages);
        }
        if (Number.class.isAssignableFrom((Class<?>)datatype)) {
            this.validateNumeric((Class<? extends Number>)datatype, (Number)attribute.getValue(modelObject), attribute, modelObject, messages);
        }
    }

    private void validateString(String value, PolicyAttribute attribute, IModelObject modelObject, MessageList messages) {
        int maxLength;
        int byteLength;
        StringLengthConstraint stringLengthConstraint = this.config.getStringLengthConstraint();
        if (stringLengthConstraint != null && (byteLength = value.getBytes(stringLengthConstraint.stringEncoding()).length) > (maxLength = stringLengthConstraint.maxStringByteLength())) {
            messages.add(this.config.createMessageForStringLengthViolation(attribute, modelObject, byteLength, maxLength));
        }
    }

    private void validateNumeric(Class<? extends Number> datatype, Number value, PolicyAttribute attribute, IModelObject modelObject, MessageList messages) {
        NumericConstraint numericConstraint = this.config.getNumericConstraint(datatype);
        if (numericConstraint != null) {
            BigDecimal bigDecimalValue = this.toBigDecimal(value);
            if (bigDecimalValue == null) {
                return;
            }
            int actualPrecision = bigDecimalValue.precision();
            int actualScale = bigDecimalValue.scale();
            if (actualPrecision > numericConstraint.precision()) {
                messages.add(this.config.createMessageForPrecisionViolation(attribute, modelObject, datatype, actualPrecision, numericConstraint.precision()));
            }
            if (actualScale > numericConstraint.scale()) {
                messages.add(this.config.createMessageForScaleViolation(attribute, modelObject, datatype, actualScale, numericConstraint.scale()));
            }
        }
    }

    private BigDecimal toBigDecimal(Number value) {
        Number number = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Decimal.class, Short.class, Integer.class, Long.class, Float.class, Double.class}, (Object)number, n)) {
            case -1 -> null;
            case 0 -> {
                BigDecimal bd;
                yield bd = (BigDecimal)number;
            }
            case 1 -> {
                Decimal decimal = (Decimal)number;
                yield new BigDecimal(decimal.toString());
            }
            case 2 -> {
                Short s = (Short)number;
                yield BigDecimal.valueOf(s.shortValue());
            }
            case 3 -> {
                Integer i = (Integer)number;
                yield BigDecimal.valueOf(i.intValue());
            }
            case 4 -> {
                Long l = (Long)number;
                yield BigDecimal.valueOf(l);
            }
            case 5 -> {
                Float f = (Float)number;
                yield new BigDecimal(f.toString());
            }
            case 6 -> {
                Double d = (Double)number;
                yield BigDecimal.valueOf(d);
            }
            default -> null;
        };
    }
}

