/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.runtime.ClassloaderRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepository;

public interface IRuntimeRepositoryLookup
extends Serializable {
    public IRuntimeRepository getRuntimeRepository();

    public static IRuntimeRepositoryLookup byToC(String tocPath) {
        return RuntimeRepositoryLookupByToC.create(tocPath);
    }

    public static final class RuntimeRepositoryLookupByToC
    implements IRuntimeRepositoryLookup {
        private static final long serialVersionUID = 1L;
        private static final Map<String, IRuntimeRepository> REPOSITORIES = new ConcurrentHashMap<String, IRuntimeRepository>();
        private final String tocPath;

        RuntimeRepositoryLookupByToC(String tocPath) {
            this.tocPath = tocPath;
        }

        RuntimeRepositoryLookupByToC(String tocPath, ClassloaderRuntimeRepository classloaderRuntimeRepository) {
            this(tocPath);
            REPOSITORIES.put(tocPath, classloaderRuntimeRepository);
        }

        private static RuntimeRepositoryLookupByToC create(String tocPath) {
            RuntimeRepositoryLookupByToC lookup = new RuntimeRepositoryLookupByToC(tocPath);
            IRuntimeRepository runtimeRepository = lookup.getRuntimeRepository();
            runtimeRepository.setRuntimeRepositoryLookup(lookup);
            return lookup;
        }

        @Override
        public IRuntimeRepository getRuntimeRepository() {
            return REPOSITORIES.computeIfAbsent(this.tocPath, ClassloaderRuntimeRepository::create);
        }
    }
}

