/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepositoryLookup;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public class ProductConfiguration
implements Serializable {
    static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final long serialVersionUID = 2579369976921239373L;
    private static final String XML_ATTRIBUTE_PRODUCT_CMPT = "productCmpt";
    private transient IProductComponent productCmpt;
    private transient IProductComponentGeneration productCmptGeneration;

    public ProductConfiguration() {
    }

    public ProductConfiguration(IProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    public void setProductComponent(IProductComponent productCmpt) {
        this.productCmpt = productCmpt;
        this.productCmptGeneration = null;
    }

    public void resetProductCmptGeneration() {
        this.productCmptGeneration = null;
    }

    public IProductComponent getProductComponent() {
        return this.productCmpt;
    }

    public IProductComponentGeneration getProductCmptGeneration(Calendar effectiveFrom) {
        return Optional.ofNullable(this.productCmpt).map(p -> this.getProductCmptGenerationInternal(effectiveFrom)).orElse(null);
    }

    private IProductComponentGeneration getProductCmptGenerationInternal(Calendar effectiveFrom) {
        if (this.productCmptGeneration == null) {
            this.productCmptGeneration = this.loadProductCmptGeneration(effectiveFrom);
        }
        return this.productCmptGeneration;
    }

    private IProductComponentGeneration loadProductCmptGeneration(Calendar effectiveFrom) {
        return this.productCmpt.getGenerationBase(effectiveFrom);
    }

    public void setProductCmptGeneration(IProductComponentGeneration newGeneration) {
        if (newGeneration == null) {
            this.setProductComponent(null);
        } else {
            this.updateProductCmptAndGeneration(newGeneration);
        }
    }

    private void updateProductCmptAndGeneration(IProductComponentGeneration newGeneration) {
        this.setProductComponent(newGeneration.getProductComponent());
        this.productCmptGeneration = newGeneration;
    }

    public void copy(ProductConfiguration otherObject) {
        this.productCmpt = otherObject.productCmpt;
        this.productCmptGeneration = otherObject.productCmptGeneration;
    }

    public void initFromXml(Element objectEl, IRuntimeRepository productRepository) {
        String productCmptId = objectEl.getAttribute(XML_ATTRIBUTE_PRODUCT_CMPT);
        if (!IpsStringUtils.isEmpty(productCmptId)) {
            IProductComponent existingProductCmpt = productRepository.getExistingProductComponent(productCmptId);
            this.setProductComponent(existingProductCmpt);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getRuntimeId());
        s.writeObject(this.getValidFrom());
        s.writeObject(this.getRepositoryLookup());
    }

    private String getRuntimeId() {
        if (this.productCmpt != null) {
            return this.productCmpt.getId();
        }
        return null;
    }

    private Date getValidFrom() {
        if (this.productCmptGeneration != null) {
            return this.productCmptGeneration.getValidFrom(TIME_ZONE);
        }
        return null;
    }

    private IRuntimeRepositoryLookup getRepositoryLookup() {
        if (this.productCmpt != null) {
            IRuntimeRepositoryLookup runtimeRepositoryLookup = this.productCmpt.getRepository().getRuntimeRepositoryLookup();
            this.checkRuntimeRepositoryLookup(runtimeRepositoryLookup);
            return runtimeRepositoryLookup;
        }
        return null;
    }

    private void checkRuntimeRepositoryLookup(IRuntimeRepositoryLookup runtimeRepositoryLookup) {
        if (runtimeRepositoryLookup == null) {
            throw new IllegalStateException("For serialization of policy component classes you need to set a IRuntimeRepositoryLookup in your runtime repository.");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String runtimeId = (String)s.readObject();
        Date validFromDate = (Date)s.readObject();
        IRuntimeRepositoryLookup runtimeRepositoryLookup = (IRuntimeRepositoryLookup)s.readObject();
        if (runtimeRepositoryLookup != null) {
            this.initProductConfiguration(runtimeId, validFromDate, runtimeRepositoryLookup);
        }
    }

    private void initProductConfiguration(String runtimeId, Date validFromDate, IRuntimeRepositoryLookup runtimeRepositoryLookup) {
        IRuntimeRepository runtimeRepository = runtimeRepositoryLookup.getRuntimeRepository();
        this.initProductCmpt(runtimeId, runtimeRepository);
        this.initGeneration(runtimeId, validFromDate, runtimeRepository);
    }

    private void initProductCmpt(String runtimeId, IRuntimeRepository runtimeRepository) {
        if (runtimeId != null) {
            this.productCmpt = runtimeRepository.getProductComponent(runtimeId);
        }
    }

    private void initGeneration(String runtimeId, Date validFromDate, IRuntimeRepository runtimeRepository) {
        if (validFromDate != null) {
            Calendar validFrom = Calendar.getInstance(TIME_ZONE);
            validFrom.setTime(validFromDate);
            this.productCmptGeneration = runtimeRepository.getProductComponentGeneration(runtimeId, validFrom);
        }
    }
}

