/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.Map;
import java.util.TreeMap;
import org.faktorips.runtime.internal.tableindex.AbstractMapStructure;
import org.faktorips.runtime.internal.tableindex.MergeAndCopyStructure;
import org.faktorips.runtime.internal.tableindex.SearchStructure;
import org.faktorips.runtime.internal.tableindex.TwoColumnRange;
import org.faktorips.values.ObjectUtil;

public class TwoColumnRangeStructure<K extends Comparable<? super K>, V extends SearchStructure<R>, R>
extends AbstractMapStructure<TwoColumnRange<K>, V, R>
implements MergeAndCopyStructure<TwoColumnRangeStructure<K, V, R>> {
    TwoColumnRangeStructure() {
        super(new TreeMap());
    }

    public static <K extends Comparable<? super K>, V extends SearchStructure<R>, R> TwoColumnRangeStructure<K, V, R> create() {
        return new TwoColumnRangeStructure<K, V, R>();
    }

    public static <K extends Comparable<? super K>, V extends SearchStructure<R>, R> TwoColumnRangeStructure<K, V, R> createWith(K lowerBound, K upperBound, V value) {
        TwoColumnRangeStructure<K, V, R> structure = new TwoColumnRangeStructure<K, V, R>();
        structure.put(lowerBound, upperBound, value);
        return structure;
    }

    public void put(K lower, K upper, V value) {
        this.put(lower, upper, true, true, value);
    }

    public void put(K lower, K upper, boolean lowerInclusive, boolean upperInclusive, V value) {
        TwoColumnRange<K> key = new TwoColumnRange<K>(lower, upper, lowerInclusive, upperInclusive);
        this.put(key, value);
    }

    @Override
    public void put(TwoColumnRange<K> key, V value) {
        new OverlappingRangePutter<K, V>(this.getMap()).put(key, value);
    }

    @Override
    protected TreeMap<TwoColumnRange<K>, V> getMap() {
        return (TreeMap)super.getMap();
    }

    @Override
    public SearchStructure<R> get(Object key) {
        if (ObjectUtil.isNull((Object)key)) {
            return this.emptyResult();
        }
        TwoColumnRange<K> twoColumnKey = this.createTwoColumnKey(key);
        V result = this.getMatchingValue(twoColumnKey);
        return this.getValidResult(result);
    }

    private TwoColumnRange<K> createTwoColumnKey(Object key) {
        Comparable kKey = (Comparable)key;
        return new TwoColumnRange<Comparable>(kKey, kKey);
    }

    private V getMatchingValue(TwoColumnRange<K> twoColumnKey) {
        Map.Entry floorEntry = ((TreeMap)this.getMap()).floorEntry(twoColumnKey);
        if (this.isMatchingEntry(twoColumnKey, floorEntry)) {
            return (V)((SearchStructure)floorEntry.getValue());
        }
        return null;
    }

    private boolean isMatchingEntry(TwoColumnRange<K> twoColumnKey, Map.Entry<TwoColumnRange<K>, V> floorEntry) {
        return floorEntry != null && twoColumnKey.compareToUpperBound(floorEntry.getKey()) <= 0;
    }

    @Override
    public void merge(TwoColumnRangeStructure<K, V, R> map) {
        super.merge(map);
    }

    @Override
    public TwoColumnRangeStructure<K, V, R> copy() {
        return this.fillCopy(new TwoColumnRangeStructure<K, V, R>());
    }

    private static class OverlappingRangePutter<K extends Comparable<? super K>, V extends MergeAndCopyStructure<V>> {
        private TreeMap<TwoColumnRange<K>, V> treeMap;
        private RangeEntry<K, V> overlappedEntry;
        private RangeEntry<K, V> newEntry;
        private RangeEntry<K, V> lo;
        private RangeEntry<K, V> mid;
        private RangeEntry<K, V> hi;

        public OverlappingRangePutter(TreeMap<TwoColumnRange<K>, V> treeMap) {
            this.treeMap = treeMap;
        }

        public void put(TwoColumnRange<K> key, V value) {
            this.putRespectingOverlapping(new RangeEntry<K, V>(key, value));
        }

        private void putRespectingOverlapping(RangeEntry<K, V> entry) {
            this.newEntry = entry;
            if (this.findOverlappedRange()) {
                this.splitUpOverlappingRanges();
            } else {
                this.putNonOverlappingRange(entry);
            }
        }

        private void splitUpOverlappingRanges() {
            this.createLoMidHiRanges();
            this.removeOverlappedRange();
            if (this.lo != null) {
                this.putNonOverlappingRange(this.lo);
            }
            this.putNonOverlappingRange(this.mid);
            if (this.hi != null) {
                this.putRespectingOverlapping(this.hi);
            }
        }

        private void createLoMidHiRanges() {
            int compareLowerBound = this.newEntry.key.compareTo(this.overlappedEntry.key);
            int compareUpperBound = this.newEntry.key.compareToUpperBound(this.overlappedEntry.key);
            if (compareLowerBound < 0) {
                this.createLoMidHiRanges(compareUpperBound, this.newEntry, this.overlappedEntry);
            } else {
                this.createLoMidHiRanges(-compareUpperBound, this.overlappedEntry, this.newEntry);
            }
            if (compareLowerBound == 0) {
                this.lo = null;
            }
        }

        private void createLoMidHiRanges(int compareUpperBound, RangeEntry<K, V> lowerEntry, RangeEntry<K, V> higherEntry) {
            this.createLower(lowerEntry, higherEntry);
            if (compareUpperBound < 0) {
                this.createMiddle(lowerEntry, higherEntry);
                this.createHigher(lowerEntry, higherEntry);
            } else {
                this.mergedMiddle(higherEntry, lowerEntry.value);
                if (compareUpperBound == 0) {
                    this.hi = null;
                } else {
                    this.createHigher(higherEntry, lowerEntry);
                }
            }
        }

        private void createLower(RangeEntry<K, V> lowerEntry, RangeEntry<K, V> upperEntry) {
            TwoColumnRange keyBelow = new TwoColumnRange(lowerEntry.key.getLowerBound(), upperEntry.key.getLowerBound(), lowerEntry.key.isLowerInclusive(), !upperEntry.key.isLowerInclusive());
            this.lo = new RangeEntry(keyBelow, lowerEntry.value);
        }

        private void createMiddle(RangeEntry<K, V> lowerEntry, RangeEntry<K, V> upperEntry) {
            TwoColumnRange keyBelow = new TwoColumnRange(upperEntry.key.getLowerBound(), lowerEntry.key.getUpperBound(), upperEntry.key.isLowerInclusive(), lowerEntry.key.isUpperInclusive());
            Object mergedValue = upperEntry.value.copy();
            mergedValue.merge(lowerEntry.value);
            this.mid = new RangeEntry(keyBelow, mergedValue);
        }

        private void mergedMiddle(RangeEntry<K, V> rangeEntry, V newValue) {
            V mergedValue = rangeEntry.value.copy();
            mergedValue.merge(newValue);
            this.mid = new RangeEntry(rangeEntry.key, mergedValue);
        }

        private void createHigher(RangeEntry<K, V> lowerEntry, RangeEntry<K, V> upperEntry) {
            TwoColumnRange keyAbove = new TwoColumnRange(lowerEntry.key.getUpperBound(), upperEntry.key.getUpperBound(), !lowerEntry.key.isUpperInclusive(), upperEntry.key.isUpperInclusive());
            this.hi = new RangeEntry(keyAbove, upperEntry.value);
        }

        private void removeOverlappedRange() {
            this.treeMap.remove(this.overlappedEntry.key);
        }

        private void putNonOverlappingRange(RangeEntry<K, V> pair) {
            this.treeMap.put(pair.key, pair.value);
        }

        private boolean findOverlappedRange() {
            Map.Entry floorEntry = this.treeMap.floorEntry(this.newEntry.key);
            if (floorEntry != null && floorEntry.getKey().isOverlapping(this.newEntry.key)) {
                this.overlappedEntry = new RangeEntry(floorEntry.getKey(), (MergeAndCopyStructure)floorEntry.getValue());
                return true;
            }
            Map.Entry ceilingEntry = this.treeMap.ceilingEntry(this.newEntry.key);
            if (ceilingEntry != null && this.newEntry.key.isOverlapping(ceilingEntry.getKey())) {
                this.overlappedEntry = new RangeEntry(ceilingEntry.getKey(), (MergeAndCopyStructure)ceilingEntry.getValue());
                return true;
            }
            return false;
        }

        private static class RangeEntry<K extends Comparable<? super K>, V extends MergeAndCopyStructure<V>> {
            private final TwoColumnRange<K> key;
            private final V value;

            public RangeEntry(TwoColumnRange<K> key, V value) {
                this.key = key;
                this.value = value;
            }

            public String toString() {
                return this.getClass().getSimpleName() + " [key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "]";
            }
        }
    }
}

