/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.enumtype.EnumAttribute;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.test.IpsTestCaseBase;

public class IpsTestFailure {
    private IpsTestCaseBase testCase;
    private Throwable throwable;
    private Object expectedValue;
    private Object actualValue;
    private String testObject;
    private String testedAttribute;
    private String message;

    public IpsTestFailure(IpsTestCaseBase test, Throwable t) {
        this.testCase = test;
        this.throwable = t;
    }

    public IpsTestFailure(IpsTestCaseBase test, Object expectedValue, Object actualValue) {
        this.testCase = test;
        this.expectedValue = expectedValue;
        this.actualValue = actualValue;
    }

    public IpsTestFailure(IpsTestCaseBase test, Object expectedValue, Object actualValue, String testObject, String testedAttribute, String message) {
        this(test, expectedValue, actualValue);
        this.testObject = testObject;
        this.testedAttribute = testedAttribute;
        this.message = message;
    }

    public IpsTestFailure(IpsTestCaseBase test) {
        this.testCase = test;
    }

    public IpsTestCaseBase getTestCase() {
        return this.testCase;
    }

    public String getTestObject() {
        return this.testObject;
    }

    public String getTestedAttribute() {
        return this.testedAttribute;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isError() {
        return this.throwable != null;
    }

    public boolean isFailedAssertion() {
        return !this.isError();
    }

    public Object getExpectedValue() {
        return this.expectedValue;
    }

    public Object getActualValue() {
        return this.actualValue;
    }

    public String getActualValueAsString() {
        if (this.actualValue == null) {
            return "<null>";
        }
        if (IpsModel.isEnumType(this.actualValue.getClass())) {
            EnumType enumType = IpsModel.getEnumType(this.actualValue);
            EnumAttribute idAttribute = enumType.getIdAttribute();
            Object value = idAttribute.getValue(this.actualValue);
            return String.valueOf(value);
        }
        return String.valueOf(this.actualValue);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "Failure in: " + this.testCase.getQualifiedName() + ", Object: " + this.testObject + ", Attribute: " + this.testedAttribute + ", Actual value: " + String.valueOf(this.actualValue) + ", Expected value: " + String.valueOf(this.expectedValue);
    }
}

