/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.xml;

import java.util.Optional;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.ProductConfiguration;
import org.faktorips.runtime.xml.IIpsXmlAdapter;

public class IpsProductConfigurationXmlAdapter
implements IIpsXmlAdapter<String, ProductConfiguration> {
    private final IRuntimeRepository repository;

    public IpsProductConfigurationXmlAdapter(IRuntimeRepository repository) {
        this.repository = repository;
    }

    @Override
    public String marshal(ProductConfiguration config) throws Exception {
        if (config == null || config.getProductComponent() == null) {
            return null;
        }
        return config.getProductComponent().getId();
    }

    @Override
    public ProductConfiguration unmarshal(String id) throws Exception {
        IProductComponent productComponent = this.getProductComponentFor(id);
        return new ProductConfiguration(productComponent);
    }

    private IProductComponent getProductComponentFor(String id) {
        return Optional.ofNullable(id).map(this.repository::getProductComponent).orElse(null);
    }
}

