/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.toc.AbstractReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.FormulaTestTocEntry;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.table.TableStructureKind;
import org.w3c.dom.Element;

public class ReadonlyTableOfContents
extends AbstractReadonlyTableOfContents {
    private Map<String, ProductCmptTocEntry> pcIdTocEntryMap;
    private Map<String, ProductCmptTocEntry> pcNameTocEntryMap;
    private Map<String, Map<String, ProductCmptTocEntry>> kindIdTocEntryListMap;
    private Map<String, TableContentTocEntry> tableImplClassTocEntryMap;
    private Map<String, TableContentTocEntry> tableContentNameTocEntryMap;
    private Map<String, TestCaseTocEntry> testCaseNameTocEntryMap;
    private Map<String, ModelTypeTocEntry> modelTypeNameTocEntryMap;
    private Map<String, EnumContentTocEntry> enumContentImplClassTocEntryMap;
    private Map<String, EnumXmlAdapterTocEntry> enumXmlAdapterTocEntryMap;
    private Map<Class<?>, Map<String, CustomTocEntryObject<?>>> otherTocEntryMaps;

    public ReadonlyTableOfContents() {
        super(ReadonlyTableOfContents.class.getClassLoader());
    }

    public ReadonlyTableOfContents(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void initFromXml(Element tocElement) {
        int size = tocElement.getChildNodes().getLength();
        this.initHashMaps(size);
        super.initFromXml(tocElement);
    }

    protected void initHashMaps(int tocSize) {
        this.pcIdTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.pcNameTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.kindIdTocEntryListMap = new HashMap<String, Map<String, ProductCmptTocEntry>>(tocSize);
        this.tableImplClassTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.tableContentNameTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.testCaseNameTocEntryMap = new HashMap<String, TestCaseTocEntry>();
        this.modelTypeNameTocEntryMap = new HashMap<String, ModelTypeTocEntry>(tocSize / 4);
        this.enumContentImplClassTocEntryMap = new HashMap<String, EnumContentTocEntry>(tocSize / 4);
        this.enumXmlAdapterTocEntryMap = new HashMap<String, EnumXmlAdapterTocEntry>(tocSize / 4);
        this.otherTocEntryMaps = new HashMap();
    }

    @Override
    protected void internalAddEntry(TocEntryObject entry) {
        TocEntryObject tocEntryObject = entry;
        Objects.requireNonNull(tocEntryObject);
        TocEntryObject tocEntryObject2 = tocEntryObject;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProductCmptTocEntry.class, TableContentTocEntry.class, FormulaTestTocEntry.class, TestCaseTocEntry.class, ModelTypeTocEntry.class, EnumContentTocEntry.class, EnumXmlAdapterTocEntry.class, CustomTocEntryObject.class}, (Object)tocEntryObject2, n)) {
            case 0: {
                ProductCmptTocEntry productCmptEntry = (ProductCmptTocEntry)tocEntryObject2;
                this.pcIdTocEntryMap.put(productCmptEntry.getIpsObjectId(), productCmptEntry);
                this.pcNameTocEntryMap.put(productCmptEntry.getIpsObjectQualifiedName(), productCmptEntry);
                this.getVersions(productCmptEntry.getKindId()).put(productCmptEntry.getVersionId(), productCmptEntry);
                break;
            }
            case 1: {
                TableContentTocEntry tableEntry = (TableContentTocEntry)tocEntryObject2;
                TableContentTocEntry previousTocEntry = this.tableImplClassTocEntryMap.put(entry.getImplementationClassName(), tableEntry);
                this.removePreviousSingleContent(entry, previousTocEntry);
                this.tableContentNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), tableEntry);
                break;
            }
            case 2: {
                FormulaTestTocEntry formulaTestEntry = (FormulaTestTocEntry)tocEntryObject2;
                this.testCaseNameTocEntryMap.put(formulaTestEntry.getIpsObjectQualifiedName(), formulaTestEntry);
                break;
            }
            case 3: {
                TestCaseTocEntry testCaseEntry = (TestCaseTocEntry)tocEntryObject2;
                this.testCaseNameTocEntryMap.put(testCaseEntry.getIpsObjectQualifiedName(), testCaseEntry);
                break;
            }
            case 4: {
                ModelTypeTocEntry modelTypeEntry = (ModelTypeTocEntry)tocEntryObject2;
                this.modelTypeNameTocEntryMap.put(modelTypeEntry.getIpsObjectQualifiedName(), modelTypeEntry);
                break;
            }
            case 5: {
                EnumContentTocEntry enumContentEntry = (EnumContentTocEntry)tocEntryObject2;
                this.addEnumContentTocEntry(enumContentEntry);
                break;
            }
            case 6: {
                EnumXmlAdapterTocEntry enumXmlAdapterEntry = (EnumXmlAdapterTocEntry)tocEntryObject2;
                this.enumXmlAdapterTocEntryMap.put(entry.getIpsObjectId(), enumXmlAdapterEntry);
                break;
            }
            case 7: {
                CustomTocEntryObject tocEntry = (CustomTocEntryObject)tocEntryObject2;
                this.putTypedTocEntryToMap(tocEntry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entry type " + String.valueOf(entry));
            }
        }
    }

    protected boolean isModifiable() {
        return false;
    }

    protected boolean internalRemoveEntry(TocEntryObject entry) {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException("Table of contents is not modifiable");
        }
        TocEntryObject tocEntryObject = entry;
        Objects.requireNonNull(tocEntryObject);
        TocEntryObject tocEntryObject2 = tocEntryObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProductCmptTocEntry.class, TableContentTocEntry.class, FormulaTestTocEntry.class, TestCaseTocEntry.class, ModelTypeTocEntry.class, EnumContentTocEntry.class, EnumXmlAdapterTocEntry.class, CustomTocEntryObject.class}, (Object)tocEntryObject2, n)) {
            case 0 -> {
                ProductCmptTocEntry prodEntry = (ProductCmptTocEntry)tocEntryObject2;
                boolean removed = this.pcIdTocEntryMap.remove(prodEntry.getIpsObjectId()) != null;
                this.pcNameTocEntryMap.remove(prodEntry.getIpsObjectQualifiedName());
                Map<String, ProductCmptTocEntry> versions = this.getVersions(prodEntry.getKindId());
                versions.remove(prodEntry.getVersionId());
                yield removed;
            }
            case 1 -> {
                TableContentTocEntry tableEntry = (TableContentTocEntry)tocEntryObject2;
                boolean removed = this.tableImplClassTocEntryMap.remove(tableEntry.getImplementationClassName()) != null;
                yield removed |= this.tableContentNameTocEntryMap.remove(tableEntry.getIpsObjectQualifiedName()) != null;
            }
            case 2 -> {
                FormulaTestTocEntry formulaCaseEntry = (FormulaTestTocEntry)tocEntryObject2;
                if (this.testCaseNameTocEntryMap.remove(entry.getIpsObjectQualifiedName()) != null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                TestCaseTocEntry testCaseEntry = (TestCaseTocEntry)tocEntryObject2;
                if (this.testCaseNameTocEntryMap.remove(entry.getIpsObjectQualifiedName()) != null) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                ModelTypeTocEntry modelTypeEntry = (ModelTypeTocEntry)tocEntryObject2;
                if (this.modelTypeNameTocEntryMap.remove(entry.getIpsObjectQualifiedName()) != null) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                EnumContentTocEntry enumTypeEntry = (EnumContentTocEntry)tocEntryObject2;
                if (this.enumContentImplClassTocEntryMap.remove(entry.getImplementationClassName()) != null) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                EnumXmlAdapterTocEntry enumXmlAdapterEntry = (EnumXmlAdapterTocEntry)tocEntryObject2;
                if (this.enumXmlAdapterTocEntryMap.remove(entry.getIpsObjectId()) != null) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                CustomTocEntryObject tocEntry = (CustomTocEntryObject)tocEntryObject2;
                Map<String, CustomTocEntryObject<?>> map = this.otherTocEntryMaps.get(tocEntry.getRuntimeObjectClass());
                if (map != null && map.remove(tocEntry.getIpsObjectQualifiedName()) != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unknown entry type " + String.valueOf(entry));
        };
    }

    private void removePreviousSingleContent(TocEntryObject entry, TableContentTocEntry previousTocEntry) {
        if (previousTocEntry != null) {
            try {
                TableStructure tableStructure = IpsModel.getTableStructure(this.getClassLoader().loadClass(entry.getImplementationClassName()));
                if (tableStructure.getKind().equals((Object)TableStructureKind.SINGLE_CONTENT)) {
                    this.tableContentNameTocEntryMap.remove(previousTocEntry.getIpsObjectQualifiedName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void addEnumContentTocEntry(TocEntryObject entry) {
        EnumContentTocEntry previousEntry = this.enumContentImplClassTocEntryMap.get(entry.getImplementationClassName());
        if (previousEntry == null || IpsStringUtils.isEmpty(previousEntry.getXmlResourceName())) {
            this.enumContentImplClassTocEntryMap.put(entry.getImplementationClassName(), (EnumContentTocEntry)entry);
        }
    }

    private <T> void putTypedTocEntryToMap(CustomTocEntryObject<T> tocEntry) {
        Map otherTocEntryMap = this.otherTocEntryMaps.computeIfAbsent(tocEntry.getRuntimeObjectClass(), $ -> new HashMap());
        otherTocEntryMap.put(tocEntry.getIpsObjectQualifiedName(), tocEntry);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries() {
        return new ArrayList<ProductCmptTocEntry>(this.pcIdTocEntryMap.values());
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String id) {
        return this.pcIdTocEntryMap.get(id);
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("VersionId must not be null!");
        }
        return this.getVersions(kindId).get(versionId);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries(String kindId) {
        return new ArrayList<ProductCmptTocEntry>(this.getVersions(kindId).values());
    }

    private Map<String, ProductCmptTocEntry> getVersions(String kindId) {
        return this.kindIdTocEntryListMap.computeIfAbsent(kindId, $ -> new TreeMap());
    }

    @Override
    public List<TableContentTocEntry> getTableTocEntries() {
        return new ArrayList<TableContentTocEntry>(this.tableContentNameTocEntryMap.values());
    }

    @Override
    public TableContentTocEntry getTableTocEntryByClassname(String implementationClass) {
        return this.tableImplClassTocEntryMap.get(implementationClass);
    }

    @Override
    public TableContentTocEntry getTableTocEntryByQualifiedTableName(String qualifiedTableName) {
        return this.tableContentNameTocEntryMap.get(qualifiedTableName);
    }

    @Override
    public List<TestCaseTocEntry> getTestCaseTocEntries() {
        return new ArrayList<TestCaseTocEntry>(this.testCaseNameTocEntryMap.values());
    }

    @Override
    public TestCaseTocEntry getTestCaseTocEntryByQName(String qName) {
        return this.testCaseNameTocEntryMap.get(qName);
    }

    @Override
    public Set<ModelTypeTocEntry> getModelTypeTocEntries() {
        return new HashSet<ModelTypeTocEntry>(this.modelTypeNameTocEntryMap.values());
    }

    @Override
    public List<EnumContentTocEntry> getEnumContentTocEntries() {
        return new ArrayList<EnumContentTocEntry>(this.enumContentImplClassTocEntryMap.values());
    }

    @Override
    public EnumContentTocEntry getEnumContentTocEntry(String className) {
        return this.enumContentImplClassTocEntryMap.get(className);
    }

    @Override
    public Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries() {
        return new HashSet<EnumXmlAdapterTocEntry>(this.enumXmlAdapterTocEntryMap.values());
    }

    public List<TocEntryObject> getEntries() {
        TreeSet<TocEntryObject> sortedEntries = new TreeSet<TocEntryObject>(Comparator.comparing(TocEntryObject::getPackageName).thenComparing(TocEntryObject::getUnqualifiedName).thenComparing(TocEntry::getXmlElementTag));
        sortedEntries.addAll(this.pcIdTocEntryMap.values());
        sortedEntries.addAll(this.tableContentNameTocEntryMap.values());
        sortedEntries.addAll(this.testCaseNameTocEntryMap.values());
        sortedEntries.addAll(this.modelTypeNameTocEntryMap.values());
        sortedEntries.addAll(this.enumContentImplClassTocEntryMap.values());
        sortedEntries.addAll(this.enumXmlAdapterTocEntryMap.values());
        for (Map<String, CustomTocEntryObject<?>> otherTocEntryMap : this.otherTocEntryMaps.values()) {
            sortedEntries.addAll(otherTocEntryMap.values());
        }
        return new ArrayList<TocEntryObject>(sortedEntries);
    }

    @Override
    public <T> CustomTocEntryObject<T> getCustomTocEntry(Class<T> type, String ipsObjectQualifiedName) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        if (otherTocEntryMap != null) {
            return this.castCustomEntryObject(ipsObjectQualifiedName, otherTocEntryMap);
        }
        return null;
    }

    private <T> CustomTocEntryObject<T> castCustomEntryObject(String ipsObjectQualifiedName, Map<String, CustomTocEntryObject<?>> otherTocEntryMap) {
        return otherTocEntryMap.get(ipsObjectQualifiedName);
    }

    @Override
    public <T extends IRuntimeObject> List<CustomTocEntryObject<T>> getTypedTocEntries(Class<T> type) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        ArrayList<CustomTocEntryObject<T>> list = new ArrayList<CustomTocEntryObject<T>>();
        if (otherTocEntryMap != null) {
            Collection<CustomTocEntryObject<?>> values = otherTocEntryMap.values();
            Iterator<CustomTocEntryObject<?>> iterator = values.iterator();
            while (iterator.hasNext()) {
                CustomTocEntryObject<?> typedTocEntryObject;
                CustomTocEntryObject<?> tocEntryObject = typedTocEntryObject = iterator.next();
                list.add(tocEntryObject);
            }
        }
        return list;
    }
}

