/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensibleEnum;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumAttribute;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Documentation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.util.MessagesHelper;
import org.faktorips.runtime.util.ReflectionHelper;
import org.faktorips.runtime.util.StringBuilderJoiner;
import org.faktorips.values.ListUtil;

public class EnumType
extends ModelElement {
    public static final String KIND_NAME = "EnumType";
    private static final ConcurrentHashMap<Class<?>, List<?>> ENUMVALUECACHE = new ConcurrentHashMap();
    private final MessagesHelper messagesHelper;
    private final List<String> attributeNames;
    private final LinkedHashMap<String, EnumAttribute> attributeModels;
    private final IpsExtensibleEnum ipsExtensibleEnum;
    private final Class<?> enumTypeClass;

    public EnumType(Class<?> enumTypeClass) {
        super(enumTypeClass.getAnnotation(IpsEnumType.class).name(), enumTypeClass.getAnnotation(IpsExtensionProperties.class), Deprecation.of(AnnotatedDeclaration.from(enumTypeClass)));
        IpsEnumType annotation = enumTypeClass.getAnnotation(IpsEnumType.class);
        this.attributeNames = Arrays.asList(annotation.attributeNames());
        this.attributeModels = EnumAttribute.createFrom(this, enumTypeClass);
        this.ipsExtensibleEnum = enumTypeClass.getAnnotation(IpsExtensibleEnum.class);
        this.messagesHelper = this.createMessageHelper(enumTypeClass.getAnnotation(IpsDocumented.class), enumTypeClass.getClassLoader());
        this.enumTypeClass = enumTypeClass;
    }

    public boolean isExtensible() {
        return this.ipsExtensibleEnum != null;
    }

    public String getEnumContentQualifiedName() {
        return this.isExtensible() ? this.ipsExtensibleEnum.enumContentName() : null;
    }

    public List<EnumAttribute> getAttributes() {
        return new ArrayList<EnumAttribute>(this.attributeModels.values());
    }

    public EnumAttribute getAttribute(String name) {
        return this.attributeModels.get(IpsStringUtils.toLowerFirstChar(name));
    }

    public List<String> getAttributenames() {
        return this.attributeNames;
    }

    public EnumAttribute getIdAttribute() {
        return this.findMarkedAttribute("Identifier", EnumAttribute::isIdentifier);
    }

    public EnumAttribute getDisplayNameAttribute() {
        return this.findMarkedAttribute("DisplayName", EnumAttribute::isDisplayName);
    }

    public static <T> List<T> getValuesFromType(Class<T> enumClass) {
        return Collections.unmodifiableList(ENUMVALUECACHE.computeIfAbsent(enumClass, EnumType::findEnumValuesDefinedInType));
    }

    private static <T> List<T> findEnumValuesDefinedInType(Class<T> enumClass) {
        if (enumClass.isEnum()) {
            return Arrays.asList(enumClass.getEnumConstants());
        }
        return ReflectionHelper.findStaticFieldValue(enumClass, "VALUES").map(Collections::unmodifiableList).orElseGet(List::of);
    }

    private EnumAttribute findMarkedAttribute(String marker, AttributeMatcher matcher) {
        for (EnumAttribute attributeModel : this.attributeModels.values()) {
            if (!matcher.matches(attributeModel)) continue;
            return attributeModel;
        }
        throw new IllegalStateException("No attribute of the enum \"" + this.getName() + "\" is marked as " + marker);
    }

    @Override
    public MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    public Class<?> getEnumClass() {
        return this.enumTypeClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isExtensible()) {
            sb.append('[');
            sb.append(this.getEnumContentQualifiedName());
            sb.append(']');
        }
        sb.append('(');
        StringBuilderJoiner.join(sb, this.attributeNames);
        sb.append(')');
        return sb.toString();
    }

    public Optional<EnumType> findSuperEnumType() {
        return Arrays.stream(this.getEnumClass().getInterfaces()).filter(IpsModel::isEnumType).findFirst().map(IpsModel::getEnumType);
    }

    @Override
    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        return Documentation.of(this, type, locale, fallback, this::findSuperEnumType);
    }

    public void validate(MessageList list, IValidationContext context, List<?> enumValues) {
        Objects.requireNonNull(list, "list must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(enumValues, "enumValues must not be null");
        enumValues.forEach(enumValue -> this.validate(list, context, enumValue));
        this.getAttributes().stream().filter(EnumAttribute::isUnique).forEach(a -> this.validateUniqueValues(list, context, enumValues, (EnumAttribute)a));
    }

    private void validateUniqueValues(MessageList list, IValidationContext context, List<?> enumValues, EnumAttribute a) {
        this.mapAttributeValuesToEnumValues(enumValues, a).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> {
            String allDuplicates = ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining(", "));
            ((List)e.getValue()).forEach(v -> a.addErrorMessage(list, context, "ENUM_ATTRIBUTE-NOT_UNIQUE", "Validation.AttributeNotUnique", v, a.getLabel(context.getLocale()), allDuplicates));
        });
    }

    private <T> Map<Object, List<T>> mapAttributeValuesToEnumValues(List<T> enumValues, EnumAttribute enumAttribute) {
        return enumValues.stream().collect(Collectors.toMap(enumAttribute::getValue, List::of, ListUtil::join));
    }

    public void validate(MessageList list, IValidationContext context, Object enumValue) {
        Objects.requireNonNull(list, "list must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(enumValue, "enumValues must not be null");
        if (!this.getEnumClass().isInstance(enumValue)) {
            throw new IllegalArgumentException(String.valueOf(enumValue) + " is not a " + String.valueOf(this));
        }
        this.getAttributes().forEach(a -> a.validate(list, context, enumValue));
    }

    @FunctionalInterface
    private static interface AttributeMatcher {
        public boolean matches(EnumAttribute var1);
    }
}

