/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EnumSaxHandler
extends DefaultHandler {
    private static final String ENUM_VALUE_NAME = "EnumValue";
    private static final String ENUM_ATTRIBUTE_VALUE_NAME = "EnumAttributeValue";
    private List<List<Object>> enumValues = new ArrayList<List<Object>>();
    private List<Object> enumValue;
    private StringBuilder stringBuilder;
    private List<LocalizedString> localizedStrings;
    private InternationalString internationalString;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ENUM_VALUE_NAME.equals(qName)) {
            this.enumValue = new ArrayList<Object>();
        } else if (ENUM_ATTRIBUTE_VALUE_NAME.equals(qName)) {
            this.stringBuilder = new StringBuilder();
        } else if ("InternationalString".equals(qName)) {
            this.localizedStrings = new ArrayList<LocalizedString>();
        } else if ("LocalizedString".equals(qName)) {
            Locale locale = new Locale(attributes.getValue("locale"));
            String text = attributes.getValue("text");
            this.localizedStrings.add(new LocalizedString(locale, text));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ENUM_ATTRIBUTE_VALUE_NAME.equals(qName)) {
            if (this.enumValue == null) {
                throw new SAXException("The xml content for this enumeration is not valid. Encountered a tag \"EnumAttributeValue\" that is not embedded in a tag \"EnumAttributeValue\"");
            }
            if (this.internationalString != null) {
                this.enumValue.add(this.internationalString);
                this.internationalString = null;
            } else {
                this.enumValue.add(this.stringBuilder.toString());
                this.stringBuilder = null;
            }
        } else if (ENUM_VALUE_NAME.equals(qName)) {
            this.enumValues.add(this.enumValue);
            this.enumValue = null;
        } else if ("InternationalString".equals(qName)) {
            this.internationalString = new DefaultInternationalString(this.localizedStrings);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.stringBuilder != null) {
            char[] dest = new char[len];
            System.arraycopy(buf, offset, dest, 0, len);
            this.stringBuilder.append(dest);
        }
    }

    public List<List<Object>> getEnumValueList() {
        return this.enumValues;
    }
}

