/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.IModelObjectDeltaVisitor;
import org.faktorips.values.ObjectUtil;

public class ModelObjectDelta
implements IModelObjectDelta {
    private static final int STRUCTURAL_CHANGES = 30;
    private final IModelObject original;
    private final IModelObject referenceObject;
    private Class<?> modelClass;
    private int kind;
    private int kindOfChange;
    private String association;
    private SortedSet<String> changedProperties = null;
    private final List<IModelObjectDelta> children = new ArrayList<IModelObjectDelta>(0);

    public static final ModelObjectDelta newDelta(IModelObject object, IModelObject refObject, IDeltaComputationOptions options) {
        if (object != null && refObject != null && !object.getClass().equals(refObject.getClass())) {
            return new ModelObjectDelta(object, refObject, 1, 8);
        }
        ModelObjectDelta delta = ModelObjectDelta.newEmptyDelta(object, refObject);
        if (object instanceof IConfigurableModelObject && refObject != null) {
            IConfigurableModelObject confObject = (IConfigurableModelObject)object;
            IConfigurableModelObject confRefObject = (IConfigurableModelObject)refObject;
            delta.checkPropertyChange("productComponent", confObject.getProductComponent(), confRefObject.getProductComponent(), options);
            delta.checkPropertyChange("productCmptGeneration", confObject.getProductCmptGeneration(), confRefObject.getProductCmptGeneration(), options);
        }
        return delta;
    }

    public static final ModelObjectDelta newEmptyDelta(IModelObject object, IModelObject refObject) {
        return new ModelObjectDelta(object, refObject, 0, 0);
    }

    public static final void createChildDeltas(ModelObjectDelta delta, IModelObject original, IModelObject refObject, String association, IDeltaComputationOptions options) {
        if (delta == null) {
            return;
        }
        if (original == null) {
            if (refObject != null) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObject, association));
            }
            return;
        }
        if (refObject == null) {
            delta.addChildDelta(ModelObjectDelta.newRemoveDelta(original, association));
            return;
        }
        if (options.isSame(original, refObject)) {
            IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObject, options);
            delta.addChildDelta(childDelta);
            return;
        }
        if (options.getMethod(association) == IDeltaComputationOptions.ComputationMethod.BY_POSITION) {
            delta.addChildDelta(ModelObjectDelta.newDifferentObjectAtPositionChangedDelta(original, refObject, association));
        } else if (options.getMethod(association) == IDeltaComputationOptions.ComputationMethod.BY_OBJECT) {
            delta.addChildDelta(ModelObjectDelta.newRemoveDelta(original, association));
            delta.addChildDelta(ModelObjectDelta.newAddDelta(refObject, association));
        } else {
            throw new RuntimeException("Unknown delta computation method " + (Object)((Object)options.getMethod(association)));
        }
    }

    public static final void createChildDeltas(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        if (delta == null) {
            return;
        }
        if (options.getMethod(association) == IDeltaComputationOptions.ComputationMethod.BY_POSITION) {
            ModelObjectDelta.createChildDeltasPerPosition(delta, originals, refObjects, association, options);
        } else if (options.getMethod(association) == IDeltaComputationOptions.ComputationMethod.BY_OBJECT) {
            ModelObjectDelta.createChildDeltasPerObject(delta, originals, refObjects, association, options);
        } else {
            throw new RuntimeException("Unknown delta computation method " + (Object)((Object)options.getMethod(association)));
        }
    }

    private static void createChildDeltasPerPosition(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        int max = Math.max(originals.size(), refObjects.size());
        int i = 0;
        while (i < max) {
            IModelObject original = ModelObjectDelta.getModelObject(originals, i);
            IModelObject refObject = ModelObjectDelta.getModelObject(refObjects, i);
            if (original != null) {
                if (refObject == null) {
                    delta.addChildDelta(ModelObjectDelta.newRemoveDelta(original, association));
                } else if (options.isSame(original, refObject)) {
                    IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObject, options);
                    delta.addChildDelta(childDelta);
                } else {
                    delta.addChildDelta(ModelObjectDelta.newDifferentObjectAtPositionChangedDelta(original, refObject, association));
                }
            } else if (refObject != null) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObject, association));
            } else {
                throw new RuntimeException("Error in delta computation. Both objects null in assocation " + association);
            }
            ++i;
        }
    }

    private static IModelObject getModelObject(List<? extends IModelObject> originals, int index) {
        if (index < originals.size()) {
            return originals.get(index);
        }
        return null;
    }

    private static void createChildDeltasPerObject(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        int removeCounter = 0;
        int size = originals.size();
        int i = 0;
        while (i < size) {
            IModelObjectDelta childDelta = ModelObjectDelta.createRemoveMoveOrChangeDelta(originals.get(i), i, refObjects, association, options);
            delta.addChildDelta(childDelta);
            if (childDelta.isRemoved()) {
                ++removeCounter;
            }
            ++i;
        }
        int refSize = refObjects.size();
        if (size - removeCounter == refSize) {
            return;
        }
        int i2 = 0;
        while (i2 < refSize) {
            boolean exists = false;
            int j = 0;
            while (j < size) {
                if (options.isSame(originals.get(j), refObjects.get(i2))) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                delta.addChildDelta(ModelObjectDelta.newAddDelta(refObjects.get(i2), association));
            }
            ++i2;
        }
    }

    private static final IModelObjectDelta createRemoveMoveOrChangeDelta(IModelObject original, int position, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        int refSize = refObjects.size();
        if (position < refSize && options.isSame(original, refObjects.get(position))) {
            IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refObjects.get(position), options);
            return childDelta;
        }
        int i = 0;
        while (i < refSize) {
            IModelObject refModelObject;
            if (i != position && options.isSame(original, refModelObject = refObjects.get(i))) {
                IModelObjectDelta childDelta = ((IDeltaSupport)((Object)original)).computeDelta(refModelObject, options);
                ((ModelObjectDelta)childDelta).markMoved();
                return childDelta;
            }
            ++i;
        }
        return ModelObjectDelta.newRemoveDelta(original, association);
    }

    public static final ModelObjectDelta newAddDelta(IModelObject addedObject, String association) {
        return new ModelObjectDelta(null, addedObject, 16, association);
    }

    public static final ModelObjectDelta newRemoveDelta(IModelObject removedObject, String association) {
        return new ModelObjectDelta(removedObject, null, 8, association);
    }

    public static final ModelObjectDelta newDifferentObjectAtPositionChangedDelta(IModelObject original, IModelObject refObject, String association) {
        return new ModelObjectDelta(original, refObject, 2, association);
    }

    public static final ModelObjectDelta newChangeDelta(IModelObject original, IModelObject refObject, int kindOfChange) {
        return new ModelObjectDelta(original, refObject, 1, kindOfChange);
    }

    private ModelObjectDelta(IModelObject original, IModelObject referenceModelObject, int kind, String association) {
        this(original, referenceModelObject, kind, 0);
        this.association = association;
    }

    private ModelObjectDelta(IModelObject original, IModelObject referenceModelObject, int deltaKind, int kindOfChange) {
        this.original = original;
        this.referenceObject = referenceModelObject;
        this.modelClass = original != null ? original.getClass() : referenceModelObject.getClass();
        this.kind = deltaKind;
        this.kindOfChange = kindOfChange;
    }

    public void addChildDelta(IModelObjectDelta childDelta) {
        if (childDelta == null || childDelta.isEmpty()) {
            return;
        }
        if ((childDelta.getKind() & 0x1E) > 0) {
            this.kindOfChange |= 1;
        }
        if (childDelta.isChanged()) {
            this.kindOfChange |= 4;
        }
        this.kind |= 1;
        this.children.add(childDelta);
    }

    @Override
    public IModelObject getOriginalObject() {
        return this.original;
    }

    @Override
    public IModelObject getReferenceObject() {
        return this.referenceObject;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public int getKindOfChange() {
        return this.kindOfChange;
    }

    @Override
    public String getAssociation() {
        return this.association;
    }

    public void checkPropertyChange(String property, Object value1, Object value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (!ObjectUtil.equals((Object)value1, (Object)value2)) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, int value1, int value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, boolean value1, boolean value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, double value1, double value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, float value1, float value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, char value1, char value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void markPropertyChanged(String property) {
        if (this.changedProperties == null) {
            this.changedProperties = new TreeSet<String>();
        }
        this.changedProperties.add(property);
        this.kind |= 1;
        this.kindOfChange |= 2;
    }

    @Override
    public boolean isClassChanged() {
        return (this.kindOfChange & 8) > 0;
    }

    @Override
    public boolean isPropertyChanged() {
        return (this.kindOfChange & 2) > 0;
    }

    @Override
    public List<String> getChangedProperties() {
        if (this.changedProperties == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.changedProperties);
    }

    @Override
    public boolean isPropertyChanged(String propertyName) {
        if (this.changedProperties == null || propertyName == null) {
            return false;
        }
        return this.changedProperties.contains(propertyName);
    }

    public void markMoved() {
        this.kind |= 4;
    }

    @Override
    public boolean isMoved() {
        return (this.kind & 4) > 0;
    }

    @Override
    public boolean isDifferentObjectAtPosition() {
        return (this.kind & 2) > 0;
    }

    @Override
    public boolean isAdded() {
        return (this.kind & 0x10) > 0;
    }

    @Override
    public boolean isChanged() {
        return (this.kind & 1) > 0;
    }

    @Override
    public boolean isChildChanged() {
        return (this.kindOfChange & 4) > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.kind == 0;
    }

    @Override
    public boolean isRemoved() {
        return (this.kind & 8) > 0;
    }

    @Override
    public boolean isStructureChanged() {
        return (this.kindOfChange & 1) > 0;
    }

    @Override
    public List<IModelObjectDelta> getChildDeltas() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<IModelObjectDelta> getChildDeltas(int kind) {
        ArrayList<IModelObjectDelta> childrenOfKind = new ArrayList<IModelObjectDelta>();
        for (IModelObjectDelta child : this.children) {
            if ((child.getKind() & kind) <= 0) continue;
            childrenOfKind.add(child);
        }
        return childrenOfKind;
    }

    @Override
    public void accept(IModelObjectDeltaVisitor visitor) {
        if (visitor.visit(this)) {
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).accept(visitor);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer, "");
        return buffer.toString();
    }

    public void toString(StringBuffer buffer, String indentation) {
        buffer.append(indentation);
        if (this.isAdded()) {
            buffer.append("+");
            buffer.append(this.referenceObject);
        } else if (this.isRemoved()) {
            buffer.append("-");
            buffer.append(this.original);
        } else if (this.isDifferentObjectAtPosition()) {
            buffer.append("differentObject");
        } else {
            buffer.append(this.isChanged() ? "*" : "empty ");
            buffer.append(this.original);
        }
        if (this.isMoved()) {
            buffer.append(" (moved)");
        }
        if (this.changedProperties != null) {
            boolean first = true;
            for (String changedProperty : this.changedProperties) {
                if (first) {
                    buffer.append(" [");
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(changedProperty);
            }
            if (!first) {
                buffer.append(']');
            }
        }
        buffer.append(System.getProperty("line.separator"));
        for (IModelObjectDelta delta : this.getChildDeltas()) {
            ((ModelObjectDelta)delta).toString(buffer, String.valueOf(indentation) + "    ");
        }
    }
}

