/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.RuntimeObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProductComponent
extends RuntimeObject
implements IProductComponent,
IXmlPersistenceSupport {
    private static final String IS_NULL = "isNull";
    private static final String VALID_TO = "validTo";
    private String id;
    private transient IRuntimeRepository repository;
    private String productKindId;
    private String versionId;
    private DateTime validTo;

    public ProductComponent(IRuntimeRepository repository, String id, String productKindId, String versionId) {
        if (repository == null) {
            throw new NullPointerException("RuntimeRepository was null!");
        }
        if (id == null) {
            throw new NullPointerException("Id was null!");
        }
        if (productKindId == null) {
            throw new NullPointerException("ProductKindId was null");
        }
        if (versionId == null) {
            throw new NullPointerException("VersionId was null");
        }
        this.repository = repository;
        this.id = id;
        this.productKindId = productKindId;
        this.versionId = versionId;
    }

    @Override
    public String getKindId() {
        return this.productKindId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public DateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(DateTime validTo) {
        this.validTo = validTo;
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    @Override
    public IProductComponentGeneration getGenerationBase(Calendar effectiveDate) {
        return this.getRepository().getProductComponentGeneration(this.id, effectiveDate);
    }

    @Override
    public IProductComponentGeneration getLatestProductComponentGeneration() {
        return this.getRepository().getLatestProductComponentGeneration(this);
    }

    @Override
    public void initFromXml(Element cmptElement) {
        Element validToNode = (Element)cmptElement.getElementsByTagName(VALID_TO).item(0);
        this.validTo = validToNode == null || Boolean.parseBoolean(validToNode.getAttribute(IS_NULL)) ? null : DateTime.parseIso(validToNode.getTextContent());
        Map<String, Element> propertyElements = ProductComponentXmlUtil.getPropertyElements(cmptElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitReferencesFromXml(ProductComponentXmlUtil.getLinkElements(cmptElement));
        this.initExtensionPropertiesFromXml(cmptElement);
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> linkElements) {
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Element toXml(Document document) {
        return this.toXml(document, true);
    }

    public Element toXml(Document document, boolean includeGenerations) {
        Element prodCmptElement = document.createElement("ProductComponent");
        this.writeValidToToXml(prodCmptElement);
        this.writePropertiesToXml(prodCmptElement);
        this.writeReferencesToXml(prodCmptElement);
        this.writeExtensionPropertiesToXml(prodCmptElement);
        if (includeGenerations) {
            List<IProductComponentGeneration> generations = this.getRepository().getProductComponentGenerations(this);
            for (IProductComponentGeneration generation : generations) {
                ProductComponentGeneration gen = (ProductComponentGeneration)generation;
                prodCmptElement.appendChild(gen.toXml(document));
            }
        }
        return prodCmptElement;
    }

    private void writeValidToToXml(Element prodCmptElement) {
        Element validToElement = prodCmptElement.getOwnerDocument().createElement(VALID_TO);
        if (this.validTo != null) {
            validToElement.setAttribute(IS_NULL, Boolean.FALSE.toString());
            validToElement.setTextContent(this.validTo.toIsoFormat());
            prodCmptElement.appendChild(validToElement);
        } else {
            validToElement.setAttribute(IS_NULL, Boolean.TRUE.toString());
        }
    }

    protected void writePropertiesToXml(Element element) {
        throw new UnsupportedOperationException("The method toXml() is currently not supported, as the required methods were not generated. To activate toXml() please check your FIPS Builder properties and make sure \"Generated toXml Support\" is set to true.");
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        return null;
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        return new ArrayList<IProductComponentLink<? extends IProductComponent>>();
    }

    protected void writeReferencesToXml(Element element) {
    }
}

