/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.ValidationRuleConfiguration;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.valueset.IntegerRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ProductComponentGeneration
extends RuntimeObject
implements IProductComponentGeneration,
IXmlPersistenceSupport {
    private ProductComponent productCmpt;
    private DateTime validFrom;
    private IFormulaEvaluator formulaEvaluator;
    private Map<String, ValidationRuleConfiguration> nameToValidationRuleConfigMap = new HashMap<String, ValidationRuleConfiguration>();
    private Map<String, String> availableFormulars = new LinkedHashMap<String, String>();

    public ProductComponentGeneration(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public IConfigurableModelObject createPolicyComponent() {
        throw new RuntimeException("Product component does not configure a policy component.");
    }

    @Override
    public final IProductComponent getProductComponent() {
        return this.productCmpt;
    }

    @Override
    public final IProductComponentGeneration getPreviousGeneration() {
        return this.getRepository().getPreviousProductComponentGeneration(this);
    }

    @Override
    public final IProductComponentGeneration getNextGeneration() {
        return this.getRepository().getNextProductComponentGeneration(this);
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.productCmpt.getRepository();
    }

    public final long getValidFromInMillisec(TimeZone zone) {
        return this.validFrom.toDate(zone).getTime();
    }

    @Override
    public final Date getValidFrom(TimeZone zone) {
        return this.validFrom.toDate(zone);
    }

    public void setValidFrom(DateTime newValidFrom) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (newValidFrom == null) {
            throw new NullPointerException();
        }
        this.validFrom = newValidFrom;
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    @Override
    public void initFromXml(Element genElement) {
        if (this.validFrom != null && this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validFrom = DateTime.parseIso(genElement.getAttribute("validFrom"));
        Map<String, Element> propertyElements = ProductComponentXmlUtil.getPropertyElements(genElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitTableUsagesFromXml(propertyElements);
        this.doInitReferencesFromXml(ProductComponentXmlUtil.getLinkElements(genElement));
        this.doInitFormulaFromXml(genElement);
        this.doInitValidationRuleConfigsFromXml(genElement);
        this.initExtensionPropertiesFromXml(genElement);
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> map) {
    }

    protected void doInitTableUsagesFromXml(Map<String, Element> map) {
    }

    protected void doInitFormulaFromXml(Element genElement) {
        IFormulaEvaluatorFactory factory;
        this.availableFormulars.putAll(ProductComponentXmlUtil.getAvailableFormulars(genElement));
        if (this.formulaEvaluator != null) {
            return;
        }
        if (this.getRepository() != null && (factory = this.getRepository().getFormulaEvaluatorFactory()) != null) {
            LinkedHashMap<String, String> expressions = new LinkedHashMap<String, String>();
            NodeList formulas = genElement.getElementsByTagName("Formula");
            int i = 0;
            while (i < formulas.getLength()) {
                Element aFormula = (Element)formulas.item(i);
                String name = aFormula.getAttribute("formulaSignature");
                NodeList nodeList = aFormula.getElementsByTagName("compiledExpression");
                if (nodeList.getLength() != 1) {
                    throw new RuntimeException("Expression for Formula: " + name + " not found");
                }
                Element expression = (Element)nodeList.item(0);
                String formulaExpression = expression.getTextContent();
                expressions.put(name, formulaExpression);
                ++i;
            }
            this.formulaEvaluator = factory.createFormulaEvaluator(this, expressions);
        }
    }

    protected boolean isFormulaAvailable(String formularSignature) {
        String expression = this.availableFormulars.get(formularSignature);
        return !IpsStringUtils.isBlank(expression);
    }

    protected void doInitValidationRuleConfigsFromXml(Element genElement) {
        NodeList nl = genElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && "ValidationRuleConfig".equals(node.getNodeName())) {
                Element childElement = (Element)nl.item(i);
                ValidationRuleConfiguration config = new ValidationRuleConfiguration(childElement);
                this.nameToValidationRuleConfigMap.put(config.getRuleName(), config);
            }
            ++i;
        }
    }

    Map<String, ValidationRuleConfiguration> getNameToValidationRuleConfigMap() {
        return this.nameToValidationRuleConfigMap;
    }

    protected Element getRangeElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Range");
    }

    protected NodeList getEnumNodeList(Element configElement) {
        Element enumElement = this.getEnumElement(configElement);
        NodeList nl = enumElement.getElementsByTagName("Value");
        return nl;
    }

    private Element getEnumElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Enum");
    }

    private Element getValueSetElement(Element configElement) {
        if (configElement == null) {
            throw new NullPointerException();
        }
        Element valueSetElement = XmlUtil.getFirstElement(configElement, "ValueSet");
        if (valueSetElement == null) {
            throw new NullPointerException();
        }
        return valueSetElement;
    }

    public static void addToCardinalityMap(Map<String, IntegerRange> cardinalityMap, String targetId, Element relationElement) {
        String maxStr = relationElement.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? new Integer(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(relationElement.getAttribute("minCardinality"));
        cardinalityMap.put(targetId, new IntegerRange(minCardinality, maxCardinality));
    }

    public String toString() {
        return String.valueOf(this.getProductComponent().getId()) + "-" + this.validFrom;
    }

    protected void setProductCmpt(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public boolean isValidationRuleActivated(String ruleName) {
        ValidationRuleConfiguration ruleConfig = this.nameToValidationRuleConfigMap.get(ruleName);
        return ruleConfig != null && ruleConfig.isActive();
    }

    @Override
    public Element toXml(Document document) {
        Element genElement = document.createElement("ProductComponentGeneration");
        this.writePropertiesToXml(genElement);
        this.writeTableUsagesToXml(genElement);
        this.writeReferencesToXml(genElement);
        this.writeFormulaToXml(genElement);
        this.writeValidationRuleConfigsToXml(genElement);
        this.writeExtensionPropertiesToXml(genElement);
        return genElement;
    }

    protected void writeTableUsagesToXml(Element element) {
    }

    protected void writeTableUsageToXml(Element element, String structureUsage, String tableContentName) {
        Element tableContentElement = element.getOwnerDocument().createElement("TableContentUsage");
        tableContentElement.setAttribute("structureUsage", structureUsage);
        ValueToXmlHelper.addValueToElement(tableContentName, tableContentElement, "TableContentName");
        element.appendChild(tableContentElement);
    }

    protected void writeReferencesToXml(Element element) {
    }

    protected void writeReferenceToXml(Element element, IProductComponentLink<? extends IProductComponent> link) {
        Element linkElement = element.getOwnerDocument().createElement("Link");
        linkElement.setAttribute("association", link.getAssociationName());
        linkElement.setAttribute("target", link.getTarget().getId());
        linkElement.setAttribute("minCardinality", Integer.toString((Integer)link.getCardinality().getLowerBound()));
        linkElement.setAttribute("maxCardinality", Integer.toString((Integer)link.getCardinality().getUpperBound()));
        linkElement.setAttribute("defaultCardinality", Integer.toString(link.getCardinality().getDefaultCardinality()));
        element.appendChild(linkElement);
    }

    protected void writeFormulaToXml(Element element) {
        for (Map.Entry<String, String> expressionEntry : this.availableFormulars.entrySet()) {
            Element formula = element.getOwnerDocument().createElement("Formula");
            formula.setAttribute("formulaSignature", expressionEntry.getKey());
            ValueToXmlHelper.addValueToElement(expressionEntry.getValue(), formula, "Expression");
            if (this.formulaEvaluator != null) {
                String compiledExpression = this.formulaEvaluator.getNameToExpressionMap().get(expressionEntry.getKey());
                ValueToXmlHelper.addCDataValueToElement(compiledExpression, formula, "compiledExpression");
            }
            element.appendChild(formula);
        }
    }

    protected void writeValidationRuleConfigsToXml(Element genElement) {
        for (String vRuleName : this.nameToValidationRuleConfigMap.keySet()) {
            Element vRuleElement = genElement.getOwnerDocument().createElement("ValidationRuleConfig");
            ValidationRuleConfiguration vRule = this.nameToValidationRuleConfigMap.get(vRuleName);
            vRuleElement.setAttribute("ruleName", vRuleName);
            vRuleElement.setAttribute("active", Boolean.toString(vRule.isActive()));
            genElement.appendChild(vRuleElement);
        }
    }

    protected void writePropertiesToXml(Element generationElement) {
        throw new UnsupportedOperationException("The method toXml() is currently not supported, as the required methods were not generated. To activate toXml() please check your FIPS Builder properties and make sure \"Generated toXml Support\" is set to true.");
    }
}

