/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessagesHelper {
    private String name;
    private ClassLoader loader;
    private final Locale defaultLocale;

    public MessagesHelper(String qualifiedName, ClassLoader loader, Locale defaultLocale) {
        this.name = qualifiedName;
        this.loader = loader;
        this.defaultLocale = defaultLocale;
    }

    public String getMessage(String key, Locale locale) {
        return this.getMessageInternal(key, locale);
    }

    private String getMessageInternal(String key, Locale locale) {
        try {
            return ResourceBundle.getBundle(this.name, locale, this.loader).getString(key);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(this.name, this.defaultLocale, this.loader).getString(key);
        }
    }

    public String getMessage(String key, Locale locale, Object ... replacements) {
        String s = this.getMessage(key, locale);
        MessageFormat mf = new MessageFormat(s, locale);
        return mf.format(replacements);
    }
}

