/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAssociation;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.TypeHierarchyVisitor;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.ModelTypeAssociation;
import org.faktorips.runtime.modeltype.internal.ModelTypeAttribute;

public class ModelType
extends AbstractModelElement
implements IModelType {
    private List<IModelTypeAssociation> associations = new ArrayList<IModelTypeAssociation>();
    private Map<String, IModelTypeAssociation> associationsByName = new HashMap<String, IModelTypeAssociation>();
    private List<IModelTypeAttribute> attributes = new ArrayList<IModelTypeAttribute>();
    private Map<String, IModelTypeAttribute> attributesByName = new HashMap<String, IModelTypeAttribute>();
    private String className;
    private String superTypeName;

    public ModelType(IRuntimeRepository repository) {
        super(repository);
    }

    @Override
    public IModelTypeAssociation getDeclaredAssociation(int index) {
        return this.associations.get(index);
    }

    @Override
    public IModelTypeAssociation getDeclaredAssociation(String name) {
        return this.associationsByName.get(name);
    }

    @Override
    public List<IModelTypeAssociation> getDeclaredAssociations() {
        return Collections.unmodifiableList(this.associations);
    }

    @Override
    public List<IModelTypeAssociation> getAssociations() {
        AssociationsCollector asscCollector = new AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.result;
    }

    @Override
    public IModelTypeAssociation getAssociation(String name) {
        AssociationFinder finder = new AssociationFinder(name);
        finder.visitHierarchy(this);
        if (finder.association == null) {
            throw new IllegalArgumentException("The type " + this + "(or one of it's supertypes) hasn't got an association " + name);
        }
        return finder.association;
    }

    @Override
    public List<IModelObject> getTargetObjects(IModelObject source, String associationName) {
        return this.getAssociation(associationName).getTargetObjects(source);
    }

    @Override
    public IModelTypeAttribute getDeclaredAttribute(int index) {
        return this.attributes.get(index);
    }

    @Override
    public IModelTypeAttribute getDeclaredAttribute(String name) {
        IModelTypeAttribute attr = this.attributesByName.get(name);
        if (attr == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    @Override
    public IModelTypeAttribute getAttribute(String name) {
        AttributeFinder finder = new AttributeFinder(name);
        finder.visitHierarchy(this);
        if (finder.attribute == null) {
            throw new IllegalArgumentException("The type " + this + "(or one of it's supertypes) hasn't got an attribute " + name);
        }
        return finder.attribute;
    }

    @Override
    public List<IModelTypeAttribute> getDeclaredAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public List<IModelTypeAttribute> getAttributes() {
        AttributeCollector attrCollector = new AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.result;
    }

    @Override
    public Object getAttributeValue(IModelObject source, String attributeName) {
        return this.getAttribute(attributeName).getValue(source);
    }

    @Override
    public void setAttributeValue(IModelObject source, String attributeName, Object value) {
        this.getAttribute(attributeName).setValue(source, value);
    }

    @Override
    public Class<?> getJavaClass() throws ClassNotFoundException {
        return this.loadClass(this.className);
    }

    @Override
    public Class<?> getJavaInterface() throws ClassNotFoundException {
        String interfaceName = this.className.replace(".internal", "");
        interfaceName = String.valueOf(interfaceName.substring(0, interfaceName.lastIndexOf(46) + 1)) + 'I' + interfaceName.substring(interfaceName.lastIndexOf(46) + 1);
        return this.loadClass(interfaceName);
    }

    @Override
    public IModelType getSuperType() {
        if (this.superTypeName != null && this.superTypeName.length() > 0) {
            Class<?> superclass = this.loadClass(this.superTypeName);
            return this.getRepository().getModelType(superclass);
        }
        return null;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        super.initFromXml(parser);
        int i = 0;
        while (i < parser.getAttributeCount()) {
            if (parser.getAttributeLocalName(i).equals("class")) {
                this.className = parser.getAttributeValue(i);
            } else if (parser.getAttributeLocalName(i).equals("supertype")) {
                this.superTypeName = parser.getAttributeValue(i);
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("ExtensionProperties")) {
                        this.initExtPropertiesFromXml(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("ModelTypeAttributes")) {
                        this.initModelTypeAttributesFromXml(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("ModelTypeAssociations")) {
                        this.initModelTypeAssociationsFromXml(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("Descriptions")) {
                        this.initDescriptionsFromXml(parser);
                        break;
                    }
                    if (!parser.getLocalName().equals("Labels")) break;
                    this.initLabelsFromXml(parser);
                }
            }
            event = parser.next();
        }
    }

    private void initModelTypeAttributesFromXml(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("ModelTypeAttribute")) break;
                    ModelTypeAttribute attribute = new ModelTypeAttribute(this);
                    attribute.initFromXml(parser);
                    this.attributes.add(attribute);
                    this.attributesByName.put(attribute.getName(), attribute);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ModelTypeAttributes")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    private void initModelTypeAssociationsFromXml(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("ModelTypeAssociation")) break;
                    ModelTypeAssociation association = new ModelTypeAssociation(this);
                    association.initFromXml(parser);
                    this.associations.add(association);
                    this.associationsByName.put(association.getName(), association);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ModelTypeAssociations")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.superTypeName != null && this.superTypeName.length() > 0) {
            sb.append(" extends ");
            sb.append(this.superTypeName);
        }
        return sb.toString();
    }

    static class AssociationFinder
    extends TypeHierarchyVisitor {
        private String associationName;
        private IModelTypeAssociation association = null;

        public AssociationFinder(String attrName) {
            this.associationName = attrName;
        }

        @Override
        public boolean visitType(IModelType type) {
            this.association = (IModelTypeAssociation)((ModelType)type).associationsByName.get(this.associationName);
            return this.association == null;
        }
    }

    static class AssociationsCollector
    extends TypeHierarchyVisitor {
        List<IModelTypeAssociation> result = new ArrayList<IModelTypeAssociation>();

        AssociationsCollector() {
        }

        @Override
        public boolean visitType(IModelType type) {
            this.result.addAll(type.getDeclaredAssociations());
            return true;
        }
    }

    static class AttributeCollector
    extends TypeHierarchyVisitor {
        List<IModelTypeAttribute> result = new ArrayList<IModelTypeAttribute>(30);

        AttributeCollector() {
        }

        @Override
        public boolean visitType(IModelType type) {
            this.result.addAll(type.getDeclaredAttributes());
            return true;
        }
    }

    static class AttributeFinder
    extends TypeHierarchyVisitor {
        private String attrName;
        private IModelTypeAttribute attribute = null;

        public AttributeFinder(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public boolean visitType(IModelType type) {
            this.attribute = (IModelTypeAttribute)((ModelType)type).attributesByName.get(this.attrName);
            return this.attribute == null;
        }
    }
}

