/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAssociation;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.ModelType;

public class ModelTypeAssociation
extends AbstractModelElement
implements IModelTypeAssociation {
    private final Map<Locale, String> pluralLabelsByLocale = new HashMap<Locale, String>();
    private ModelType modelType;
    private IModelTypeAssociation.AssociationType associationType = IModelTypeAssociation.AssociationType.Association;
    private int minCardinality = 0;
    private int maxCardinality = Integer.MAX_VALUE;
    private String namePlural = null;
    private String targetJavaClassName = null;
    private boolean isProductRelevant = false;
    private boolean isDerivedUnion = false;
    private boolean isSubsetOfADerivedUnion = false;
    private Boolean isTargetRolePluralRequired = false;
    private String inverseAssociation;
    private String matchingAssociationName;
    private String matchingAssociationSource;
    private String getterName;

    public ModelTypeAssociation(ModelType modelType) {
        super(modelType.getRepository());
        this.modelType = modelType;
    }

    @Override
    public String getLabelForPlural(Locale locale) {
        String label = this.pluralLabelsByLocale.get(locale);
        return IpsStringUtils.isEmpty(label) ? this.getNamePlural() : label;
    }

    @Override
    public IModelType getModelType() {
        return this.modelType;
    }

    @Override
    public IModelTypeAssociation.AssociationType getAssociationType() {
        return this.associationType;
    }

    @Override
    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    @Override
    public int getMinCardinality() {
        return this.minCardinality;
    }

    @Override
    public String getNamePlural() {
        return this.namePlural;
    }

    @Override
    public IModelType getTarget() throws ClassNotFoundException {
        if (this.targetJavaClassName != null && this.targetJavaClassName.length() > 0) {
            Class<?> targetClass = this.loadClass(this.targetJavaClassName);
            return this.getRepository().getModelType(targetClass);
        }
        return null;
    }

    @Override
    public List<IModelObject> getTargetObjects(IModelObject source) {
        ArrayList<IModelObject> targets = new ArrayList<IModelObject>();
        try {
            Object object = this.getGetter(source).invoke((Object)source, new Object[0]);
            if (object instanceof Iterable) {
                for (Object target : (Iterable)object) {
                    targets.add((IModelObject)target);
                }
            } else if (object instanceof IModelObject) {
                targets.add((IModelObject)object);
            }
        }
        catch (IntrospectionException e) {
            this.handleGetterError(source, e);
        }
        catch (IllegalArgumentException e) {
            this.handleGetterError(source, e);
        }
        catch (IllegalAccessException e) {
            this.handleGetterError(source, e);
        }
        catch (InvocationTargetException e) {
            this.handleGetterError(source, e);
        }
        return targets;
    }

    private Method getGetter(IModelObject source) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(this.getUsedName(), source.getClass(), this.getGetterName(), null);
        return propertyDescriptor.getReadMethod();
    }

    private String getGetterName() {
        if (this.getterName == null) {
            this.getterName = "get" + this.getUsedName().substring(0, 1).toUpperCase() + this.getUsedName().substring(1);
        }
        return this.getterName;
    }

    private void handleGetterError(IModelObject source, Exception e) {
        throw new IllegalArgumentException(String.format("Could not get target %s on source object %s.", this.getUsedName(), source), e);
    }

    @Override
    public boolean isProductRelevant() {
        return this.isProductRelevant;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        super.initFromXml(parser);
        int i = 0;
        while (i < parser.getAttributeCount()) {
            this.initAttributeValuesInternal(parser, i);
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("ExtensionProperties")) {
                        this.initExtPropertiesFromXml(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("Descriptions")) {
                        this.initDescriptionsFromXml(parser);
                        break;
                    }
                    if (!parser.getLocalName().equals("Labels")) break;
                    this.initLabelsFromXml(parser);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ModelTypeAssociation")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    private void initAttributeValuesInternal(XMLStreamReader parser, int index) {
        this.initNamePluralInternal(parser, index);
        this.initTargetJavaClassNameInternal(parser, index);
        this.initMinCardinalityInternal(parser, index);
        this.initMaxCardinalityInternal(parser, index);
        this.initAssociationTypeInternal(parser, index);
        this.initProduktRelevantInternal(parser, index);
        this.initDerivedUnionInternal(parser, index);
        this.initSubsetOfDerivedUnionInternal(parser, index);
        this.initTargetRolePluralRequiredInternal(parser, index);
        this.initInverseAssociationInternal(parser, index);
        this.initMatchingAssociationNameInternal(parser, index);
        this.initMatchingAssociationSourceInternal(parser, index);
    }

    private void initNamePluralInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("namePlural")) {
            this.namePlural = parser.getAttributeValue(index);
            if (this.namePlural.length() == 0) {
                this.namePlural = null;
            }
        }
    }

    private void initTargetJavaClassNameInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("target")) {
            this.targetJavaClassName = parser.getAttributeValue(index);
        }
    }

    private void initMinCardinalityInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("minCardinality")) {
            this.minCardinality = Integer.parseInt(parser.getAttributeValue(index));
        }
    }

    private void initMaxCardinalityInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("maxCardinality")) {
            this.maxCardinality = Integer.parseInt(parser.getAttributeValue(index));
        }
    }

    private void initAssociationTypeInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("associationType")) {
            this.associationType = IModelTypeAssociation.AssociationType.valueOf(parser.getAttributeValue(index));
        }
    }

    private void initProduktRelevantInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("isProductRelevant")) {
            this.isProductRelevant = Boolean.valueOf(parser.getAttributeValue(index));
        }
    }

    private void initDerivedUnionInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("isDerivedUnion")) {
            this.isDerivedUnion = Boolean.valueOf(parser.getAttributeValue(index));
        }
    }

    private void initSubsetOfDerivedUnionInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("isSubsetOfADerivedUnion")) {
            this.isSubsetOfADerivedUnion = Boolean.valueOf(parser.getAttributeValue(index));
        }
    }

    private void initTargetRolePluralRequiredInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("isTargetRolePluralRequired")) {
            this.isTargetRolePluralRequired = Boolean.valueOf(parser.getAttributeValue(index));
        }
    }

    private void initInverseAssociationInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("inverseAssociation")) {
            this.inverseAssociation = parser.getAttributeValue(index);
        }
    }

    private void initMatchingAssociationNameInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("matchingAssociationName")) {
            this.matchingAssociationName = parser.getAttributeValue(index);
        }
    }

    private void initMatchingAssociationSourceInternal(XMLStreamReader parser, int index) {
        if (parser.getAttributeLocalName(index).equals("matchingAssociationSource")) {
            this.matchingAssociationSource = parser.getAttributeValue(index);
        }
    }

    @Override
    protected void initLabelFromXml(XMLStreamReader parser) {
        super.initLabelFromXml(parser);
        String localeCode = parser.getAttributeValue(null, "locale");
        Locale locale = IpsStringUtils.isEmpty(localeCode) ? null : new Locale(localeCode);
        String value = parser.getAttributeValue(null, "pluralValue");
        this.pluralLabelsByLocale.put(locale, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUsedName());
        sb.append(": ");
        sb.append(this.targetJavaClassName);
        sb.append('(');
        sb.append((Object)this.associationType);
        sb.append(' ');
        if (this.isDerivedUnion) {
            sb.append(", Derived Union ");
        }
        if (this.isSubsetOfADerivedUnion) {
            sb.append(", Subset of a Derived Union ");
        }
        sb.append(this.minCardinality);
        sb.append("..");
        sb.append(this.maxCardinality == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.maxCardinality));
        if (this.isProductRelevant) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getUsedName() {
        return this.isTargetRolePluralRequired != false ? this.getNamePlural() : this.getName();
    }

    @Override
    public boolean isDerivedUnion() {
        return this.isDerivedUnion;
    }

    @Override
    public boolean isSubsetOfADerivedUnion() {
        return this.isSubsetOfADerivedUnion;
    }

    @Override
    public String getInverseAssociation() {
        return this.inverseAssociation;
    }

    @Override
    public String getMatchingAssociationName() {
        return this.matchingAssociationName;
    }

    @Override
    public String getMatchingAssociationSource() {
        return this.matchingAssociationSource;
    }
}

