/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.ModelType;

public class ModelTypeAttribute
extends AbstractModelElement
implements IModelTypeAttribute {
    private ModelType modelType;
    private Class<?> datatype;
    private String datatypeName;
    private IModelTypeAttribute.ValueSetType valueSetType = IModelTypeAttribute.ValueSetType.AllValues;
    private IModelTypeAttribute.AttributeType attributeType = IModelTypeAttribute.AttributeType.CHANGEABLE;
    private boolean isProductRelevant = false;
    private String getterName;

    public ModelTypeAttribute(ModelType modelType) {
        super(modelType.getRepository());
        this.modelType = modelType;
    }

    @Override
    public IModelType getModelType() {
        return this.modelType;
    }

    @Override
    public Class<?> getDatatype() throws ClassNotFoundException {
        if (this.datatype == null) {
            this.datatype = this.findDatatype();
        }
        return this.datatype;
    }

    @Override
    public IModelTypeAttribute.AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public IModelTypeAttribute.ValueSetType getValueSetType() {
        return this.valueSetType;
    }

    @Override
    public boolean isProductRelevant() {
        return this.isProductRelevant;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        super.initFromXml(parser);
        int i = 0;
        while (i < parser.getAttributeCount()) {
            if (parser.getAttributeLocalName(i).equals("datatype")) {
                this.datatypeName = parser.getAttributeValue(i);
            } else if (parser.getAttributeLocalName(i).equals("valueSetType")) {
                this.valueSetType = IModelTypeAttribute.ValueSetType.valueOf(parser.getAttributeValue(i));
            } else if (parser.getAttributeLocalName(i).equals("attributeType")) {
                this.attributeType = IModelTypeAttribute.AttributeType.forName(parser.getAttributeValue(i));
            } else if (parser.getAttributeLocalName(i).equals("isProductRelevant")) {
                this.isProductRelevant = Boolean.valueOf(parser.getAttributeValue(i));
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("ExtensionProperties")) {
                        this.initExtPropertiesFromXml(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("Descriptions")) {
                        this.initDescriptionsFromXml(parser);
                        break;
                    }
                    if (!parser.getLocalName().equals("Labels")) break;
                    this.initLabelsFromXml(parser);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ModelTypeAttribute")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    protected Class<?> findDatatype() {
        String actualName = this.datatypeName;
        int arraydepth = 0;
        while (actualName.lastIndexOf(91) > 0) {
            actualName = actualName.substring(0, actualName.lastIndexOf(91));
            ++arraydepth;
        }
        if (arraydepth > 0) {
            actualName = "boolean".equals(actualName) ? "Z" : ("byte".equals(actualName) ? "B" : ("char".equals(actualName) ? "C" : ("double".equals(actualName) ? "D" : ("float".equals(actualName) ? "F" : ("int".equals(actualName) ? "I" : ("long".equals(actualName) ? "J" : ("short".equals(actualName) ? "S" : "L" + actualName + ";")))))));
            char[] da = new char[arraydepth];
            Arrays.fill(da, '[');
            actualName = String.valueOf(new String(da)) + actualName;
        }
        if (actualName.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (actualName.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (actualName.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (actualName.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (actualName.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (actualName.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (actualName.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (actualName.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        return this.loadClass(actualName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatypeName);
        sb.append('(');
        sb.append((Object)this.attributeType);
        sb.append(", ");
        sb.append((Object)this.valueSetType);
        if (this.isProductRelevant) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Object getValue(IModelObject source) {
        try {
            if (IModelTypeAttribute.AttributeType.CONSTANT == this.attributeType) {
                Field field = source.getClass().getField(this.getName().toUpperCase());
                return field.get(source);
            }
            return this.getGetter(source).invoke((Object)source, new Object[0]);
        }
        catch (IntrospectionException e) {
            this.handleGetterError(source, e);
        }
        catch (IllegalArgumentException e) {
            this.handleGetterError(source, e);
        }
        catch (IllegalAccessException e) {
            this.handleGetterError(source, e);
        }
        catch (InvocationTargetException e) {
            this.handleGetterError(source, e);
        }
        catch (SecurityException e) {
            this.handleGetterError(source, e);
        }
        catch (NoSuchFieldException e) {
            this.handleGetterError(source, e);
        }
        return null;
    }

    private Method getGetter(IModelObject source) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(this.getName(), source.getClass(), this.getGetterName(), null);
        return propertyDescriptor.getReadMethod();
    }

    private String getGetterName() {
        if (this.getterName == null) {
            String prefix = "";
            prefix = Boolean.TYPE.getName().equals(this.datatypeName) ? "is" : "get";
            this.getterName = String.valueOf(prefix) + this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
        }
        return this.getterName;
    }

    @Override
    public void setValue(IModelObject source, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(this.getName(), source.getClass());
            propertyDescriptor.getWriteMethod().invoke((Object)source, value);
        }
        catch (IntrospectionException e) {
            this.handleSetterError(source, value, e);
        }
        catch (IllegalArgumentException e) {
            this.handleSetterError(source, value, e);
        }
        catch (IllegalAccessException e) {
            this.handleSetterError(source, value, e);
        }
        catch (InvocationTargetException e) {
            this.handleSetterError(source, value, e);
        }
    }

    private void handleGetterError(IModelObject source, Exception e) {
        throw new IllegalArgumentException(String.format("Could not get attribute %s on source object %s.", this.getName(), source), e);
    }

    private void handleSetterError(IModelObject source, Object value, Exception e) {
        throw new IllegalArgumentException(String.format("Could not write attribute %s on source object %s to value %s.", this.getName(), source, value), e);
    }
}

