/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype;

import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.IModelType;

public interface IModelTypeAttribute
extends IModelElement {
    public static final String XML_TAG = "ModelTypeAttribute";
    public static final String XML_WRAPPER_TAG = "ModelTypeAttributes";
    public static final String PROPERTY_DATATYPE = "datatype";
    public static final String PROPERTY_VALUE_SET_TYPE = "valueSetType";
    public static final String PROPERTY_ATTRIBUTE_TYPE = "attributeType";
    public static final String PROPERTY_PRODUCT_RELEVANT = "isProductRelevant";

    public IModelType getModelType();

    public Class<?> getDatatype() throws ClassNotFoundException;

    public AttributeType getAttributeType();

    public ValueSetType getValueSetType();

    public boolean isProductRelevant();

    public Object getValue(IModelObject var1);

    public void setValue(IModelObject var1, Object var2);

    public static enum AttributeType {
        CHANGEABLE("changeable"),
        CONSTANT("constant"),
        DERIVED_ON_THE_FLY("derived"),
        DERIVED_BY_EXPLICIT_METHOD_CALL("computed");

        private final String xmlName;

        private AttributeType(String xmlName) {
            this.xmlName = xmlName;
        }

        public String toString() {
            return this.xmlName;
        }

        public static AttributeType forName(String name) {
            if ("changeable".equals(name)) {
                return CHANGEABLE;
            }
            if ("constant".equals(name)) {
                return CONSTANT;
            }
            if ("derived".equals(name)) {
                return DERIVED_ON_THE_FLY;
            }
            if ("computed".equals(name)) {
                return DERIVED_BY_EXPLICIT_METHOD_CALL;
            }
            return null;
        }
    }

    public static enum ValueSetType {
        Enum,
        Range,
        AllValues;

    }
}

