/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.modeltype.IModelElement;

public class AbstractModelElement
implements IModelElement {
    private final Map<Locale, String> labelsByLocale = new HashMap<Locale, String>();
    private final Map<Locale, String> descriptionsByLocale = new HashMap<Locale, String>();
    private Map<String, Object> extPropertyValues;
    private String name;
    private IRuntimeRepository repository;

    public AbstractModelElement(IRuntimeRepository repository) {
        this.repository = repository;
    }

    @Override
    public String getLabel(Locale locale) {
        String label = this.labelsByLocale.get(locale);
        return IpsStringUtils.isEmpty(label) ? this.getName() : label;
    }

    @Override
    public String getDescription(Locale locale) {
        String description = this.descriptionsByLocale.get(locale);
        return IpsStringUtils.isEmpty(description) ? "" : description;
    }

    @Override
    public Object getExtensionPropertyValue(String propertyId) {
        if (this.extPropertyValues == null) {
            return null;
        }
        return this.extPropertyValues.get(propertyId);
    }

    public void setExtensionPropertyValue(String propertyId, Object value) {
        if (this.extPropertyValues == null) {
            this.extPropertyValues = new HashMap<String, Object>(5);
        }
        this.extPropertyValues.put(propertyId, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            if (parser.getAttributeLocalName(i).equals("name")) {
                this.name = parser.getAttributeValue(i);
            }
            ++i;
        }
    }

    protected final void initDescriptionsFromXml(XMLStreamReader parser) throws XMLStreamException {
        Locale currentLocale = null;
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("Description")) break;
                    currentLocale = this.initDescriptionFromXml(parser);
                    break;
                }
                case 4: {
                    if (currentLocale == null || parser.isWhiteSpace()) break;
                    this.descriptionsByLocale.put(currentLocale, parser.getText());
                    currentLocale = null;
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("Descriptions")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    private Locale initDescriptionFromXml(XMLStreamReader parser) {
        Locale locale = null;
        int i = 0;
        while (i < parser.getAttributeCount()) {
            if (parser.getAttributeLocalName(i).equals("locale")) {
                String localeCode = parser.getAttributeValue(i);
                locale = IpsStringUtils.isEmpty(localeCode) ? null : new Locale(localeCode);
            }
            ++i;
        }
        return locale;
    }

    protected final void initLabelsFromXml(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("Label")) break;
                    this.initLabelFromXml(parser);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("Labels")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    protected void initLabelFromXml(XMLStreamReader parser) {
        String localeCode = parser.getAttributeValue(null, "locale");
        Locale locale = IpsStringUtils.isEmpty(localeCode) ? null : new Locale(localeCode);
        String value = parser.getAttributeValue(null, "value");
        this.labelsByLocale.put(locale, value);
    }

    @Override
    public Set<String> getExtensionPropertyIds() {
        if (this.extPropertyValues == null) {
            return new HashSet<String>(0);
        }
        return this.extPropertyValues.keySet();
    }

    @Override
    public void initExtPropertiesFromXml(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!parser.getLocalName().equals("Value")) break;
                    this.initExtPropertyValueFromXml(parser);
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("ExtensionProperties")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    private void initExtPropertyValueFromXml(XMLStreamReader parser) throws XMLStreamException {
        String id = null;
        boolean isNull = true;
        StringBuilder value = new StringBuilder();
        int i = 0;
        while (i < parser.getAttributeCount()) {
            if (parser.getAttributeLocalName(i).equals("id")) {
                id = parser.getAttributeValue(i);
            } else if (parser.getAttributeLocalName(i).equals("isNull")) {
                isNull = Boolean.valueOf(parser.getAttributeValue(i));
            }
            ++i;
        }
        if (isNull) {
            this.setExtensionPropertyValue(id, null);
        } else {
            int event = parser.next();
            while (event != 8) {
                switch (event) {
                    case 4: {
                        value.append(parser.getText().trim());
                        break;
                    }
                    case 12: {
                        value.append(parser.getText().trim());
                        break;
                    }
                    case 2: {
                        if (!parser.getLocalName().equals("Value")) break;
                        this.setExtensionPropertyValue(id, value.toString());
                        return;
                    }
                }
                event = parser.next();
            }
        }
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, this.repository.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

