/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model;

import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.AbstractComputable;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsPolicyCmptType;
import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.enumtype.EnumModel;
import org.faktorips.runtime.model.table.TableModel;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IPolicyModel;
import org.faktorips.runtime.modeltype.IProductModel;
import org.faktorips.runtime.modeltype.internal.PolicyModel;
import org.faktorips.runtime.modeltype.internal.ProductModel;

public class Models {
    private static final Memoizer<Class<? extends ITable>, TableModel> TABLE_MODEL_CACHE = new Memoizer<Class<? extends ITable>, TableModel>(new AbstractComputable<Class<? extends ITable>, TableModel>(TableModel.class){

        @Override
        public TableModel compute(Class<? extends ITable> tableObjectClass) {
            return new TableModel(tableObjectClass);
        }
    });
    private static final Memoizer<Class<?>, EnumModel> ENUM_MODEL_CACHE = new Memoizer(new AbstractComputable<Class<?>, EnumModel>(EnumModel.class){

        @Override
        public EnumModel compute(Class<?> enumObjectClass) {
            return new EnumModel(enumObjectClass);
        }
    });
    private static final Memoizer<AnnotatedDeclaration, IProductModel> PRODUCT_MODEL_CACHE = new Memoizer<AnnotatedDeclaration, IProductModel>(new AbstractComputable<AnnotatedDeclaration, IProductModel>(IProductModel.class){

        @Override
        public IProductModel compute(AnnotatedDeclaration annotatedDeclaration) {
            if (annotatedDeclaration.is(IpsProductCmptType.class)) {
                String name = annotatedDeclaration.get(IpsProductCmptType.class).name();
                return new ProductModel(name, annotatedDeclaration);
            }
            throw new IllegalArgumentException("The class " + annotatedDeclaration.getDeclarationClassName() + " is not annotated as product component type.");
        }
    });
    private static final Memoizer<AnnotatedDeclaration, IPolicyModel> POLICY_MODEL_CACHE = new Memoizer<AnnotatedDeclaration, IPolicyModel>(new AbstractComputable<AnnotatedDeclaration, IPolicyModel>(IPolicyModel.class){

        @Override
        public IPolicyModel compute(AnnotatedDeclaration annotatedModelType) {
            if (annotatedModelType.is(IpsPolicyCmptType.class)) {
                String name = annotatedModelType.get(IpsPolicyCmptType.class).name();
                return new PolicyModel(name, annotatedModelType);
            }
            throw new IllegalArgumentException("The class " + annotatedModelType.getDeclarationClassName() + " is not annotated as policy component type.");
        }
    });

    private Models() {
    }

    private static <K, V> V get(Memoizer<K, V> memoizer, K key) {
        try {
            return memoizer.compute(key);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static TableModel getTableModel(Class<? extends ITable> tableObjectClass) {
        return Models.get(TABLE_MODEL_CACHE, tableObjectClass);
    }

    public static TableModel getTableModel(ITable table) {
        return Models.getTableModel(table.getClass());
    }

    public static boolean isProductModel(Class<?> productModelClass) {
        return AnnotatedDeclaration.from(productModelClass).is(IpsProductCmptType.class);
    }

    public static IProductModel getProductModel(Class<? extends IProductComponent> productModelClass) {
        return Models.get(PRODUCT_MODEL_CACHE, AnnotatedDeclaration.from(productModelClass));
    }

    public static IProductModel getProductModel(IProductComponent productComponent) {
        return Models.getProductModel(productComponent.getClass());
    }

    public static boolean isPolicyModel(Class<?> policyModelClass) {
        return AnnotatedDeclaration.from(policyModelClass).is(IpsPolicyCmptType.class);
    }

    public static IPolicyModel getPolicyModel(Class<? extends IModelObject> policyModelClass) {
        return Models.get(POLICY_MODEL_CACHE, AnnotatedDeclaration.from(policyModelClass));
    }

    public static IPolicyModel getPolicyModel(IModelObject modelObject) {
        return Models.getPolicyModel(modelObject.getClass());
    }

    public static IModelType getModelType(Class<?> modelObjectClass) {
        AnnotatedDeclaration annotatedModelType = AnnotatedDeclaration.from(modelObjectClass);
        if (annotatedModelType.is(IpsProductCmptType.class)) {
            return Models.getProductModel(modelObjectClass.asSubclass(IProductComponent.class));
        }
        if (annotatedModelType.is(IpsPolicyCmptType.class)) {
            return Models.getPolicyModel(modelObjectClass.asSubclass(IModelObject.class));
        }
        throw new IllegalArgumentException("The given " + modelObjectClass + " is not annotated as product or policy component type.");
    }

    public static EnumModel getEnumModel(Class<?> enumObjectClass) {
        return Models.get(ENUM_MODEL_CACHE, enumObjectClass);
    }

    public static EnumModel getEnumModel(Object enumInstance) {
        return Models.getEnumModel(enumInstance.getClass());
    }
}

