/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.faktorips.runtime.model.annotation.IpsEnum;
import org.faktorips.runtime.model.annotation.IpsEnumAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumModel;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.modeltype.internal.read.SimpleTypeModelPartsReader;
import org.faktorips.runtime.util.MessagesHelper;

public class EnumAttributeModel
extends AbstractModelElement {
    private final EnumModel enumModel;
    private final Class<?> datatype;
    private final Method getterMethod;
    private final IpsEnumAttribute annotation;

    public EnumAttributeModel(EnumModel enumModel, String name, Method getterMethod) {
        super(name, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.enumModel = enumModel;
        this.datatype = getterMethod.getReturnType();
        this.getterMethod = getterMethod;
        this.annotation = getterMethod.getAnnotation(IpsEnumAttribute.class);
    }

    public Class<?> getDatatype() {
        return this.datatype;
    }

    public boolean isUnique() {
        return this.annotation.unique();
    }

    public boolean isIdentifier() {
        return this.annotation.identifier();
    }

    public boolean isDisplayName() {
        return this.annotation.displayName();
    }

    public Object getValue(Object enumInstance) {
        return this.getValue(enumInstance, Locale.getDefault());
    }

    public boolean isMultilingual() {
        return this.getterMethod.getParameterTypes().length == 1;
    }

    public Object getValue(Object enumInstance, Locale locale) {
        try {
            if (this.isMultilingual()) {
                return this.getterMethod.invoke(enumInstance, locale);
            }
            return this.getterMethod.invoke(enumInstance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw this.cantGetValueException(e, locale);
        }
        catch (IllegalArgumentException e) {
            throw this.cantGetValueException(e, locale);
        }
        catch (InvocationTargetException e) {
            throw this.cantGetValueException(e, locale);
        }
    }

    private RuntimeException cantGetValueException(Exception e, Locale locale) {
        return new RuntimeException("Can't get value for attribute \"" + this.getName() + "\"" + (this.isMultilingual() ? " for locale " + locale : ""), e);
    }

    @Override
    protected String getMessageKey(DocumentationType messageType) {
        return messageType.getKey(this.enumModel.getName(), "EnumType", this.getName());
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.enumModel.getMessageHelper();
    }

    protected static LinkedHashMap<String, EnumAttributeModel> createFrom(EnumModel enumModel, Class<?> enumClass) {
        Class<IpsEnum> parentAnnotation = IpsEnum.class;
        SimpleTypeModelPartsReader.NamesAccessor<IpsEnum> getNamesOfPartsFromParentAnnotation = new SimpleTypeModelPartsReader.NamesAccessor<IpsEnum>(){

            @Override
            public String[] getNames(IpsEnum annotation) {
                return annotation.attributeNames();
            }
        };
        Class<IpsEnumAttribute> childAnnotation = IpsEnumAttribute.class;
        SimpleTypeModelPartsReader.NameAccessor<IpsEnumAttribute> getNameOfPartFromChildAnnotation = new SimpleTypeModelPartsReader.NameAccessor<IpsEnumAttribute>(){

            @Override
            public String getName(IpsEnumAttribute annotation) {
                return annotation.name();
            }
        };
        SimpleTypeModelPartsReader.ModelElementCreator<EnumAttributeModel> createEnumAttributeModel = new SimpleTypeModelPartsReader.ModelElementCreator<EnumAttributeModel>(){

            @Override
            public EnumAttributeModel create(IModelElement modelType, String name, Method getterMethod) {
                return new EnumAttributeModel((EnumModel)modelType, name, getterMethod);
            }
        };
        SimpleTypeModelPartsReader<EnumAttributeModel, IpsEnum, IpsEnumAttribute> modelPartsReader = new SimpleTypeModelPartsReader<EnumAttributeModel, IpsEnum, IpsEnumAttribute>(parentAnnotation, getNamesOfPartsFromParentAnnotation, childAnnotation, getNameOfPartFromChildAnnotation, createEnumAttributeModel);
        return modelPartsReader.createParts(enumClass, enumModel);
    }
}

