/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsEnum;
import org.faktorips.runtime.model.annotation.IpsExtensibleEnum;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumAttributeModel;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.util.MessagesHelper;

public class EnumModel
extends AbstractModelElement {
    public static final String KIND_NAME = "EnumType";
    private final MessagesHelper messagesHelper;
    private List<String> attributeNames;
    private LinkedHashMap<String, EnumAttributeModel> attributeModels;
    private IpsExtensibleEnum ipsExtensibleEnum;

    public EnumModel(Class<?> enumTypeClass) {
        super(enumTypeClass.getAnnotation(IpsEnum.class).name(), enumTypeClass.getAnnotation(IpsExtensionProperties.class));
        IpsEnum annotation = enumTypeClass.getAnnotation(IpsEnum.class);
        this.attributeNames = Arrays.asList(annotation.attributeNames());
        this.attributeModels = EnumAttributeModel.createFrom(this, enumTypeClass);
        this.ipsExtensibleEnum = enumTypeClass.getAnnotation(IpsExtensibleEnum.class);
        this.messagesHelper = this.createMessageHelper(enumTypeClass.getAnnotation(IpsDocumented.class), enumTypeClass.getClassLoader());
    }

    public boolean isExtensible() {
        return this.ipsExtensibleEnum != null;
    }

    public String getEnumContentQualifiedName() {
        return this.isExtensible() ? this.ipsExtensibleEnum.enumContentName() : null;
    }

    public List<EnumAttributeModel> getAttributes() {
        return new ArrayList<EnumAttributeModel>(this.attributeModels.values());
    }

    public EnumAttributeModel getAttribute(String name) {
        return this.attributeModels.get(name);
    }

    public List<String> getAttributenames() {
        return this.attributeNames;
    }

    public EnumAttributeModel getIdAttribute() {
        return this.findMarkedAttribute("Identifier", new AttributeMatcher(){

            @Override
            public boolean matches(EnumAttributeModel attributeModel) {
                return attributeModel.isIdentifier();
            }
        });
    }

    public EnumAttributeModel getDisplayNameAttribute() {
        return this.findMarkedAttribute("DisplayName", new AttributeMatcher(){

            @Override
            public boolean matches(EnumAttributeModel attributeModel) {
                return attributeModel.isDisplayName();
            }
        });
    }

    private EnumAttributeModel findMarkedAttribute(String marker, AttributeMatcher matcher) {
        for (EnumAttributeModel attributeModel : this.attributeModels.values()) {
            if (!matcher.matches(attributeModel)) continue;
            return attributeModel;
        }
        throw new IllegalStateException("No attribute of the enum \"" + this.getName() + "\" is marked as " + marker);
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationType messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isExtensible()) {
            sb.append('[');
            sb.append(this.getEnumContentQualifiedName());
            sb.append(']');
        }
        sb.append("(");
        boolean first = true;
        for (String attributeName : this.attributeNames) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(attributeName);
        }
        sb.append(")");
        return sb.toString();
    }

    private static interface AttributeMatcher {
        public boolean matches(EnumAttributeModel var1);
    }
}

