/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableColumn;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.table.TableModel;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.modeltype.internal.read.SimpleTypeModelPartsReader;
import org.faktorips.runtime.util.MessagesHelper;

public class TableColumnModel
extends AbstractModelElement {
    private final Class<?> datatype;
    private final Method getterMethod;
    private final TableModel tableModel;

    protected TableColumnModel(TableModel tableModel, String name, Class<?> datatype, Method getterMethod) {
        super(name, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.tableModel = tableModel;
        this.datatype = datatype;
        this.getterMethod = getterMethod;
    }

    public Class<?> getDatatype() {
        return this.datatype;
    }

    protected Method getGetterMethod() {
        return this.getterMethod;
    }

    public Object getValue(Object row) {
        try {
            return this.getGetterMethod().invoke(row, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Can't get value for column \"" + this.getName() + "\"", e);
        }
    }

    protected static LinkedHashMap<String, TableColumnModel> createModelsFrom(TableModel tableModel, Class<? extends ITable> tableObjectClass, Class<?> tableRowClass) {
        Class<IpsTableStructure> parentAnnotation = IpsTableStructure.class;
        SimpleTypeModelPartsReader.NamesAccessor<IpsTableStructure> getNamesOfPartsFromParentAnnotation = new SimpleTypeModelPartsReader.NamesAccessor<IpsTableStructure>(){

            @Override
            public String[] getNames(IpsTableStructure annotation) {
                return annotation.columns();
            }
        };
        Class<IpsTableColumn> childAnnotation = IpsTableColumn.class;
        SimpleTypeModelPartsReader.NameAccessor<IpsTableColumn> getNameOfPartFromChildAnnotation = new SimpleTypeModelPartsReader.NameAccessor<IpsTableColumn>(){

            @Override
            public String getName(IpsTableColumn annotation) {
                return annotation.name();
            }
        };
        SimpleTypeModelPartsReader.ModelElementCreator<TableColumnModel> createTableColumnModel = new SimpleTypeModelPartsReader.ModelElementCreator<TableColumnModel>(){

            @Override
            public TableColumnModel create(IModelElement modelType, String name, Method getterMethod) {
                return new TableColumnModel((TableModel)modelType, name, getterMethod.getReturnType(), getterMethod);
            }
        };
        SimpleTypeModelPartsReader<TableColumnModel, IpsTableStructure, IpsTableColumn> modelPartsReader = new SimpleTypeModelPartsReader<TableColumnModel, IpsTableStructure, IpsTableColumn>(parentAnnotation, getNamesOfPartsFromParentAnnotation, childAnnotation, getNameOfPartFromChildAnnotation, createTableColumnModel);
        return modelPartsReader.createParts(tableObjectClass, tableRowClass, tableModel);
    }

    @Override
    protected String getMessageKey(DocumentationType messageType) {
        return messageType.getKey(this.tableModel.getName(), "TableStructure", this.getName());
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.tableModel.getMessageHelper();
    }
}

