/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.table;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.table.TableColumnModel;
import org.faktorips.runtime.model.table.TableStructureType;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.util.MessagesHelper;

public class TableModel
extends AbstractModelElement {
    public static final String KIND_NAME = "TableStructure";
    private TableStructureType type;
    private LinkedHashMap<String, TableColumnModel> columnModels;
    private List<String> columnNames;
    private final MessagesHelper messagesHelper;

    public TableModel(Class<? extends ITable> tableObjectClass) {
        super(tableObjectClass.getAnnotation(IpsTableStructure.class).name(), tableObjectClass.getAnnotation(IpsExtensionProperties.class));
        IpsTableStructure annotation = tableObjectClass.getAnnotation(IpsTableStructure.class);
        this.type = annotation.type();
        this.columnNames = Arrays.asList(annotation.columns());
        Class tableRowClass = (Class)((ParameterizedType)tableObjectClass.getGenericSuperclass()).getActualTypeArguments()[0];
        this.columnModels = TableColumnModel.createModelsFrom(this, tableObjectClass, tableRowClass);
        this.messagesHelper = this.createMessageHelper(tableObjectClass.getAnnotation(IpsDocumented.class), tableObjectClass.getClassLoader());
    }

    public TableStructureType getType() {
        return this.type;
    }

    public List<TableColumnModel> getColumns() {
        return new ArrayList<TableColumnModel>(this.columnModels.values());
    }

    public TableColumnModel getColumn(String columnName) {
        return this.columnModels.get(columnName);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Object getValue(Object tableRow, TableColumnModel column) {
        return column.getValue(tableRow);
    }

    public Object getValue(Object tableRow, String columnName) {
        return this.getValue(tableRow, this.getColumn(columnName));
    }

    public List<Object> getValues(Object tableRow) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TableColumnModel column : this.columnModels.values()) {
            values.add(this.getValue(tableRow, column));
        }
        return values;
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationType messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append((Object)this.type);
        sb.append("(");
        boolean first = true;
        for (String columnName : this.columnNames) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(columnName);
        }
        sb.append(")");
        return sb.toString();
    }
}

