/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.util.Calendar;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.internal.ModelPart;
import org.faktorips.runtime.modeltype.internal.ModelType;

public abstract class AbstractAttributeModel
extends ModelPart
implements IModelTypeAttribute {
    private final IpsAttribute attributeAnnotation;
    private final Class<?> datatype;
    private final boolean changingOverTime;

    public AbstractAttributeModel(ModelType modelType, IpsAttribute attributeAnnotation, IpsExtensionProperties extensionProperties, Class<?> datatype, boolean changingOverTime) {
        super(attributeAnnotation.name(), modelType, extensionProperties);
        this.attributeAnnotation = attributeAnnotation;
        this.datatype = datatype;
        this.changingOverTime = changingOverTime;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public Class<?> getDatatype() throws ClassNotFoundException {
        return this.datatype;
    }

    @Override
    public IModelTypeAttribute.AttributeType getAttributeType() {
        return this.attributeAnnotation.type();
    }

    @Override
    public IModelTypeAttribute.ValueSetType getValueSetType() {
        return this.attributeAnnotation.valueSetType();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatype.getSimpleName());
        sb.append('(');
        sb.append((Object)this.getAttributeType());
        sb.append(", ");
        sb.append((Object)this.getValueSetType());
        if (this.isProductRelevant()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    public abstract AbstractAttributeModel createOverwritingAttributeFor(ModelType var1);

    protected Object getRelevantProductObject(IProductComponent productComponent, Calendar effectiveDate) {
        return AbstractAttributeModel.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
    }
}

