/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAssociation;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.TypeHierarchyVisitor;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.util.MessagesHelper;

public abstract class ModelType
extends AbstractModelElement
implements IModelType {
    private final AnnotatedDeclaration annotatedDeclaration;
    private final MessagesHelper messagesHelper;

    public ModelType(String name, AnnotatedDeclaration annotatedModelType) {
        super(name, annotatedModelType.get(IpsExtensionProperties.class));
        this.annotatedDeclaration = annotatedModelType;
        IpsDocumented ipsDocumented = annotatedModelType.get(IpsDocumented.class);
        this.messagesHelper = this.createMessageHelper(ipsDocumented, annotatedModelType.getClassLoader());
    }

    protected abstract String getKindName();

    @Override
    protected String getMessageKey(DocumentationType messageType) {
        return messageType.getKey(this.getName(), this.getKindName(), "");
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    public IModelTypeAssociation getDeclaredAssociation(int index) {
        return this.getDeclaredAssociations().get(index);
    }

    @Override
    public IModelTypeAttribute getDeclaredAttribute(int index) {
        return this.getDeclaredAttributes().get(index);
    }

    @Override
    public IModelTypeAssociation getAssociation(String name) {
        AssociationFinder finder = new AssociationFinder(name);
        finder.visitHierarchy(this);
        if (finder.association == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got an association \"" + name + "\"");
        }
        return finder.association;
    }

    @Override
    public IModelTypeAttribute getAttribute(String name) {
        AttributeFinder finder = new AttributeFinder(name);
        finder.visitHierarchy(this);
        if (finder.attribute == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's supertypes) hasn't got an attribute \"" + name + "\"");
        }
        return finder.attribute;
    }

    protected AnnotatedDeclaration getAnnotatedDeclaration() {
        return this.annotatedDeclaration;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.annotatedDeclaration.getImplementationClass();
    }

    @Override
    public Class<?> getJavaInterface() {
        return this.annotatedDeclaration.getPublishedInterface();
    }

    public Class<?> getDeclarationClass() {
        return this.getJavaInterface() == null ? this.getJavaClass() : this.getJavaInterface();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.getSuperType() != null) {
            sb.append(" extends ");
            sb.append(this.getSuperType().getName());
        }
        return sb.toString();
    }

    public <T extends Annotation> Method searchDeclaredMethod(Class<T> annotationClass, AnnotatedElementMatcher<T> matcher) {
        List<Method> declaredMethods = this.getDeclaredMethods();
        for (Method method : declaredMethods) {
            if (!method.isAnnotationPresent(annotationClass) || !matcher.matches(method.getAnnotation(annotationClass))) continue;
            return method;
        }
        return null;
    }

    protected List<Method> getDeclaredMethods() {
        return this.getAnnotatedDeclaration().getDeclaredMethods();
    }

    public static abstract class AnnotatedElementMatcher<T extends Annotation> {
        public abstract boolean matches(T var1);
    }

    static class AssociationFinder
    extends TypeHierarchyVisitor {
        private String associationName;
        private IModelTypeAssociation association = null;

        public AssociationFinder(String associationName) {
            this.associationName = associationName;
        }

        @Override
        public boolean visitType(IModelType type) {
            this.association = ((ModelType)type).getDeclaredAssociation(this.associationName);
            return this.association == null;
        }
    }

    static class AssociationsCollector<T extends IModelTypeAssociation>
    extends TypeHierarchyVisitor {
        private final List<T> result = new ArrayList<T>();
        private final Set<String> associationNames = new HashSet<String>();

        AssociationsCollector() {
        }

        @Override
        public boolean visitType(IModelType type) {
            for (IModelTypeAssociation iModelTypeAssociation : type.getDeclaredAssociations()) {
                if (this.associationNames.contains(iModelTypeAssociation.getName())) continue;
                this.associationNames.add(iModelTypeAssociation.getName());
                IModelTypeAssociation castedAssociation = iModelTypeAssociation;
                this.result.add(castedAssociation);
            }
            return true;
        }

        protected List<T> getResult() {
            return this.result;
        }
    }

    static class AttributeCollector<T extends IModelTypeAttribute>
    extends TypeHierarchyVisitor {
        private final List<T> result = new ArrayList<T>(30);
        private final Set<String> attributeNames = new HashSet<String>();

        AttributeCollector() {
        }

        @Override
        public boolean visitType(IModelType type) {
            for (IModelTypeAttribute iModelTypeAttribute : type.getDeclaredAttributes()) {
                if (this.attributeNames.contains(iModelTypeAttribute.getName())) continue;
                this.attributeNames.add(iModelTypeAttribute.getName());
                IModelTypeAttribute castedAttribute = iModelTypeAttribute;
                this.result.add(castedAttribute);
            }
            return true;
        }

        public List<T> getResult() {
            return this.result;
        }
    }

    static class AttributeFinder
    extends TypeHierarchyVisitor {
        private String attrName;
        private IModelTypeAttribute attribute = null;

        public AttributeFinder(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public boolean visitType(IModelType type) {
            try {
                this.attribute = ((ModelType)type).getDeclaredAttribute(this.attrName);
                return false;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    }
}

