/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.lang.reflect.Method;
import java.util.Locale;
import org.faktorips.runtime.model.Models;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.annotation.IpsDerivedUnion;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsInverseAssociation;
import org.faktorips.runtime.model.annotation.IpsMatchingAssociation;
import org.faktorips.runtime.model.annotation.IpsSubsetOfDerivedUnion;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAssociation;
import org.faktorips.runtime.modeltype.internal.DocumentationType;
import org.faktorips.runtime.modeltype.internal.ModelPart;
import org.faktorips.runtime.modeltype.internal.ModelType;

public abstract class ModelTypeAssociation
extends ModelPart
implements IModelTypeAssociation {
    private final IpsAssociation annotation;
    private final Method getter;

    public ModelTypeAssociation(ModelType modelType, Method getterMethod) {
        super(ModelTypeAssociation.getAssociationAnnotation(getterMethod).name(), modelType, getterMethod.getAnnotation(IpsExtensionProperties.class));
        this.annotation = ModelTypeAssociation.getAssociationAnnotation(getterMethod);
        this.getter = getterMethod;
    }

    private static IpsAssociation getAssociationAnnotation(Method getterMethod) {
        return getterMethod.getAnnotation(IpsAssociation.class);
    }

    @Override
    public String getLabelForPlural(Locale locale) {
        return this.getDocumentation(locale, DocumentationType.PLURAL_LABEL, this.getNamePlural());
    }

    @Override
    public IModelTypeAssociation.AssociationType getAssociationType() {
        return this.annotation.type();
    }

    @Override
    public int getMinCardinality() {
        return this.annotation.min();
    }

    @Override
    public int getMaxCardinality() {
        return this.annotation.max();
    }

    @Override
    public String getNamePlural() {
        return this.annotation.pluralName();
    }

    @Override
    public IModelType getTarget() {
        return Models.getModelType(this.annotation.targetClass());
    }

    @Override
    public String getUsedName() {
        return this.isTargetRolePluralRequired() ? this.getNamePlural() : this.getName();
    }

    private boolean isTargetRolePluralRequired() {
        return Iterable.class.isAssignableFrom(this.getter.getReturnType());
    }

    @Override
    public boolean isDerivedUnion() {
        return this.getter.isAnnotationPresent(IpsDerivedUnion.class);
    }

    @Override
    public boolean isSubsetOfADerivedUnion() {
        return this.getter.isAnnotationPresent(IpsSubsetOfDerivedUnion.class);
    }

    @Override
    public String getInverseAssociation() {
        if (this.getter.isAnnotationPresent(IpsInverseAssociation.class)) {
            return this.getter.getAnnotation(IpsInverseAssociation.class).value();
        }
        return null;
    }

    @Override
    @Deprecated
    public boolean isProductRelevant() {
        return this.isMatchingAssociationPresent();
    }

    @Override
    public boolean isMatchingAssociationPresent() {
        return this.getter.isAnnotationPresent(IpsMatchingAssociation.class);
    }

    @Override
    public String getMatchingAssociationName() {
        if (this.getter.isAnnotationPresent(IpsMatchingAssociation.class)) {
            return this.getter.getAnnotation(IpsMatchingAssociation.class).name();
        }
        return null;
    }

    @Override
    public String getMatchingAssociationSource() {
        IModelType matchingAssociationSource = this.getMatchingAssociationSourceType();
        if (matchingAssociationSource != null) {
            return matchingAssociationSource.getName();
        }
        return null;
    }

    @Override
    public IModelType getMatchingAssociationSourceType() {
        if (this.getter.isAnnotationPresent(IpsMatchingAssociation.class)) {
            return Models.getModelType(this.getter.getAnnotation(IpsMatchingAssociation.class).source());
        }
        return null;
    }

    protected Method getGetterMethod() {
        return this.getter;
    }

    public abstract ModelTypeAssociation createOverwritingAssociationFor(ModelType var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUsedName());
        sb.append(": ");
        sb.append(this.getTarget().getName());
        sb.append('(');
        sb.append((Object)this.getAssociationType());
        sb.append(' ');
        if (this.isDerivedUnion()) {
            sb.append(", Derived Union ");
        }
        if (this.isSubsetOfADerivedUnion()) {
            sb.append(", Subset of a Derived Union ");
        }
        sb.append(this.getMinCardinality());
        sb.append("..");
        sb.append(this.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.getMaxCardinality()));
        if (this.isMatchingAssociationPresent()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }
}

