/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.lang.reflect.Field;
import java.util.Calendar;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.modeltype.IPolicyAttributeModel;
import org.faktorips.runtime.modeltype.internal.AbstractAttributeModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.valueset.ValueSet;

public class PolicyModelConstantAttribute
extends AbstractAttributeModel
implements IPolicyAttributeModel {
    private final Field field;

    public PolicyModelConstantAttribute(ModelType modelType, Field field, boolean changingOverTime) {
        super(modelType, field.getAnnotation(IpsAttribute.class), field.getAnnotation(IpsExtensionProperties.class), field.getType(), changingOverTime);
        this.field = field;
    }

    @Override
    public boolean isProductRelevant() {
        return false;
    }

    @Override
    public Object getValue(IModelObject source) {
        return this.invokeField(this.field, source);
    }

    @Override
    public void setValue(IModelObject source, Object value) {
        throw new UnsupportedOperationException("Cannot modify a constant field.");
    }

    @Override
    public PolicyModelConstantAttribute createOverwritingAttributeFor(ModelType subModelType) {
        return new PolicyModelConstantAttribute(subModelType, this.field, this.isChangingOverTime());
    }

    @Override
    public Object getDefaultValue(IConfigurableModelObject modelObject) {
        return this.getValue(modelObject);
    }

    @Override
    public Object getDefaultValue(IProductComponent source, Calendar effectiveDate) {
        throw new UnsupportedOperationException(String.valueOf(this.getName()) + " is a constant field and has no product configuration");
    }

    @Override
    public ValueSet<?> getValueSet(IModelObject modelObject, IValidationContext context) {
        throw new UnsupportedOperationException(String.valueOf(this.getName()) + " is a constant field and has no product configuration");
    }

    @Override
    public ValueSet<?> getValueSet(IProductComponent source, Calendar effectiveDate, IValidationContext context) {
        throw new UnsupportedOperationException(String.valueOf(this.getName()) + " is a constant field and has no product configuration");
    }
}

