/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.List;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.modeltype.IProductAttributeModel;
import org.faktorips.runtime.modeltype.internal.AbstractAttributeModel;
import org.faktorips.runtime.modeltype.internal.ModelType;

public class ProductAttributeModel
extends AbstractAttributeModel
implements IProductAttributeModel {
    private final Method getter;
    private final Method setter;

    public ProductAttributeModel(ModelType modelType, boolean changingOverTime, Method getter, Method setter) {
        super(modelType, getter.getAnnotation(IpsAttribute.class), getter.getAnnotation(IpsExtensionProperties.class), ProductAttributeModel.getInnermostGenericClass(getter.getGenericReturnType()), changingOverTime);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public boolean isProductRelevant() {
        return true;
    }

    @Override
    public AbstractAttributeModel createOverwritingAttributeFor(ModelType subModelType) {
        return new ProductAttributeModel(subModelType, this.isChangingOverTime(), this.getter, this.setter);
    }

    @Override
    public Object getValue(IProductComponent productComponent, Calendar effectiveDate) {
        return this.invokeMethod(this.getter, this.getRelevantProductObject(productComponent, effectiveDate), new Object[0]);
    }

    private static final Class<?> getInnermostGenericClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ProductAttributeModel.getInnermostGenericClass(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        throw new IllegalArgumentException("can't find class for " + type.toString());
    }

    @Override
    public Boolean isMultiValue() {
        return this.getter.getReturnType().equals(List.class);
    }
}

