/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.Models;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsChangingOverTime;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IPolicyModel;
import org.faktorips.runtime.modeltype.IProductAssociationModel;
import org.faktorips.runtime.modeltype.IProductAttributeModel;
import org.faktorips.runtime.modeltype.IProductModel;
import org.faktorips.runtime.modeltype.ITableUsageModel;
import org.faktorips.runtime.modeltype.TypeHierarchyVisitor;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.read.ProductAssociationModelCollector;
import org.faktorips.runtime.modeltype.internal.read.ProductAttributeModelCollector;
import org.faktorips.runtime.modeltype.internal.read.TableUsageCollector;
import org.faktorips.runtime.modeltype.internal.read.TypeModelPartsReader;

public class ProductModel
extends ModelType
implements IProductModel {
    public static final String KIND_NAME = "ProductCmptType2";
    private final AnnotatedDeclaration generationDeclaration;
    private final LinkedHashMap<String, IProductAttributeModel> attributes;
    private final LinkedHashMap<String, IProductAssociationModel> associations;
    private final LinkedHashMap<String, ITableUsageModel> tableUsages;

    public ProductModel(String name, AnnotatedDeclaration annotatedDeclaration) {
        super(name, annotatedDeclaration);
        this.generationDeclaration = this.isChangingOverTime() ? AnnotatedDeclaration.from(annotatedDeclaration.get(IpsChangingOverTime.class).value()) : null;
        ProductAttributeModelCollector attributeCollector = new ProductAttributeModelCollector();
        ProductAssociationModelCollector associationCollector = new ProductAssociationModelCollector();
        TableUsageCollector tableUsageCollector = new TableUsageCollector();
        this.initParts(attributeCollector, associationCollector, tableUsageCollector);
        this.attributes = attributeCollector.createParts(this);
        this.associations = associationCollector.createParts(this);
        this.tableUsages = tableUsageCollector.createParts(this);
    }

    private void initParts(ProductAttributeModelCollector attributeCollector, ProductAssociationModelCollector associationCollector, TableUsageCollector tableUsageCollector) {
        TypeModelPartsReader typeModelPartsReader = new TypeModelPartsReader(attributeCollector, associationCollector, tableUsageCollector);
        typeModelPartsReader.init(this.getAnnotatedDeclaration());
        typeModelPartsReader.read(this.getAnnotatedDeclaration());
        if (this.isChangingOverTime()) {
            typeModelPartsReader.read(this.generationDeclaration);
        }
    }

    @Override
    protected String getKindName() {
        return KIND_NAME;
    }

    @Override
    protected List<Method> getDeclaredMethods() {
        List<Method> result = super.getDeclaredMethods();
        if (this.isChangingOverTime()) {
            result.addAll(this.generationDeclaration.getDeclaredMethods());
        }
        return result;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.getAnnotatedDeclaration().is(IpsChangingOverTime.class);
    }

    @Override
    public boolean isConfigurationForPolicyCmptType() {
        return this.getAnnotatedDeclaration().is(IpsConfigures.class);
    }

    @Override
    public IPolicyModel getPolicyCmptType() {
        return Models.getPolicyModel(this.getAnnotatedDeclaration().get(IpsConfigures.class).value().asSubclass(IModelObject.class));
    }

    @Override
    public ITableUsageModel getTableUsage(String name) {
        TableUsageFinder finder = new TableUsageFinder(name);
        finder.visitHierarchy(this);
        if (finder.tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got a table usage \"" + name + "\"");
        }
        return finder.tableUsage;
    }

    @Override
    public List<ITableUsageModel> getDeclaredTableUsages() {
        return new ArrayList<ITableUsageModel>(this.tableUsages.values());
    }

    public ITableUsageModel getDeclaredTableUsage(String name) {
        ITableUsageModel tableUsage = this.tableUsages.get(name);
        if (tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared table usage " + name);
        }
        return tableUsage;
    }

    @Override
    public List<ITableUsageModel> getTableUsages() {
        TableUsagesCollector tuCollector = new TableUsagesCollector();
        tuCollector.visitHierarchy(this);
        return tuCollector.result;
    }

    public Class<?> getGenerationJavaClass() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getImplementationClass();
        }
        return null;
    }

    public Class<?> getGenerationJavaInterface() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getPublishedInterface();
        }
        return null;
    }

    public Class<?> getGenerationDeclarationClass() {
        return this.getGenerationJavaInterface() == null ? this.getGenerationJavaClass() : this.getGenerationJavaInterface();
    }

    @Override
    public IProductModel getSuperType() {
        Class<?> superclass = this.getJavaClass().getSuperclass();
        return Models.isProductModel(superclass) ? Models.getProductModel(superclass.asSubclass(IProductComponent.class)) : null;
    }

    @Override
    public IProductAttributeModel getDeclaredAttribute(int index) {
        return this.getDeclaredAttributes().get(index);
    }

    @Override
    public IProductAttributeModel getDeclaredAttribute(String name) {
        IProductAttributeModel attr = this.attributes.get(name);
        if (attr == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    @Override
    public List<IProductAttributeModel> getDeclaredAttributes() {
        return new ArrayList<IProductAttributeModel>(this.attributes.values());
    }

    @Override
    public IProductAttributeModel getAttribute(String name) {
        return (IProductAttributeModel)super.getAttribute(name);
    }

    @Override
    public List<IProductAttributeModel> getAttributes() {
        ModelType.AttributeCollector attrCollector = new ModelType.AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.getResult();
    }

    @Override
    public IProductAssociationModel getDeclaredAssociation(int index) {
        return (IProductAssociationModel)super.getDeclaredAssociation(index);
    }

    @Override
    public IProductAssociationModel getDeclaredAssociation(String name) {
        return this.associations.get(name);
    }

    @Override
    public List<IProductAssociationModel> getDeclaredAssociations() {
        return new ArrayList<IProductAssociationModel>(new LinkedHashSet<IProductAssociationModel>(this.associations.values()));
    }

    @Override
    public IProductAssociationModel getAssociation(String name) {
        return (IProductAssociationModel)super.getAssociation(name);
    }

    @Override
    public List<IProductAssociationModel> getAssociations() {
        ModelType.AssociationsCollector asscCollector = new ModelType.AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.getResult();
    }

    static class TableUsageFinder
    extends TypeHierarchyVisitor {
        private String tableUsageName;
        private ITableUsageModel tableUsage = null;

        public TableUsageFinder(String name) {
            this.tableUsageName = name;
        }

        @Override
        public boolean visitType(IModelType type) {
            try {
                this.tableUsage = ((ProductModel)type).getDeclaredTableUsage(this.tableUsageName);
                return false;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    }

    static class TableUsagesCollector
    extends TypeHierarchyVisitor {
        private List<ITableUsageModel> result = new ArrayList<ITableUsageModel>();

        TableUsagesCollector() {
        }

        @Override
        public boolean visitType(IModelType type) {
            this.result.addAll(((IProductModel)type).getDeclaredTableUsages());
            return true;
        }
    }
}

