/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.internal.AbstractAttributeModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.read.PartDescriptor;

abstract class AbstractAttributeDescriptor<T extends IModelTypeAttribute>
extends PartDescriptor<T> {
    private AnnotatedElement annotatedElement;
    private Method setterMethod;

    AbstractAttributeDescriptor() {
    }

    public boolean isValid() {
        return this.getAnnotatedElement() instanceof Field || this.getAnnotatedElement() instanceof Method;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    @Override
    public T create(IModelElement parentElement) {
        IModelTypeAttribute attribute;
        ModelType modelType = (ModelType)parentElement;
        if (this.isValid()) {
            return this.createValid(modelType);
        }
        IModelType superType = modelType.getSuperType();
        if (superType != null && (attribute = superType.getAttribute(this.getName())) != null) {
            AbstractAttributeModel overwritingAttribute = ((AbstractAttributeModel)attribute).createOverwritingAttributeFor(modelType);
            return (T)overwritingAttribute;
        }
        throw new IllegalArgumentException(modelType.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsAttributes but no matching @IpsAttribute could be found.");
    }

    protected abstract T createValid(ModelType var1);
}

