/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.internal.read.AnnotationProcessor;
import org.faktorips.runtime.modeltype.internal.read.PartDescriptor;

public abstract class ModelPartCollector<T extends IModelElement, D extends PartDescriptor<T>> {
    protected static final String[] NO_NAMES = new String[0];
    private final LinkedHashMap<String, D> descriptors = new LinkedHashMap();
    private List<AnnotationProcessor<?, D>> annotationProcessors;

    public ModelPartCollector(List<AnnotationProcessor<?, D>> annotationAccessors) {
        this.annotationProcessors = annotationAccessors;
    }

    public void initDescriptors(AnnotatedDeclaration annotatedDeclaration) {
        String[] stringArray = this.getNames(annotatedDeclaration);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            D descriptor = this.createDescriptor();
            ((PartDescriptor)descriptor).setName(name);
            this.descriptors.put(name, descriptor);
            ++n2;
        }
    }

    public LinkedHashMap<String, T> createParts(IModelElement parentModel) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, D> descriptorEntry : this.descriptors.entrySet()) {
            PartDescriptor descriptor = (PartDescriptor)descriptorEntry.getValue();
            Object part = descriptor.create(parentModel);
            this.addPart(result, part);
        }
        return result;
    }

    protected void addPart(LinkedHashMap<String, T> result, T part) {
        result.put(part.getName(), part);
    }

    protected abstract String[] getNames(AnnotatedDeclaration var1);

    protected abstract D createDescriptor();

    public void readAnnotations(AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
        for (AnnotationProcessor<?, D> annotationProcessor : this.annotationProcessors) {
            this.readAnnotationsInternal(annotationProcessor, annotatedDeclaration, annotatedElement);
        }
    }

    private void readAnnotationsInternal(AnnotationProcessor<?, D> annotationProcessor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
        if (annotationProcessor.accept(annotatedElement)) {
            String name = annotationProcessor.getName(annotatedElement);
            D descriptor = this.getDescriptor(name, annotatedDeclaration.getDeclarationClassName());
            annotationProcessor.process(descriptor, annotatedDeclaration, annotatedElement);
        }
    }

    protected D getDescriptor(String name, String typeName) {
        PartDescriptor descriptor = (PartDescriptor)this.descriptors.get(name);
        if (descriptor != null) {
            return (D)descriptor;
        }
        throw new IllegalArgumentException("Cannot find part " + name + " in " + typeName);
    }

    protected LinkedHashMap<String, D> getDescriptors() {
        return this.descriptors;
    }
}

