/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.model.annotation.IpsConfiguredAttribute;
import org.faktorips.runtime.modeltype.IPolicyAttributeModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.PolicyAttributeModel;
import org.faktorips.runtime.modeltype.internal.PolicyModel;
import org.faktorips.runtime.modeltype.internal.PolicyModelConstantAttribute;
import org.faktorips.runtime.modeltype.internal.read.AbstractAttributeDescriptor;
import org.faktorips.runtime.modeltype.internal.read.AttributeCollector;

public class PolicyAttributeModelCollector
extends AttributeCollector<IPolicyAttributeModel, PolicyAttributeDescriptor> {
    public PolicyAttributeModelCollector() {
        super(Arrays.asList(new AttributeCollector.IpsAttributeProcessor(), new AttributeCollector.IpsAttributeSetterProcessor()));
    }

    @Override
    protected PolicyAttributeDescriptor createDescriptor() {
        return new PolicyAttributeDescriptor();
    }

    static class PolicyAttributeDescriptor
    extends AbstractAttributeDescriptor<IPolicyAttributeModel> {
        PolicyAttributeDescriptor() {
        }

        @Override
        protected IPolicyAttributeModel createValid(ModelType modelType) {
            if (this.getAnnotatedElement() instanceof Field) {
                boolean changingOverTime = this.isChangingOverTime();
                return new PolicyModelConstantAttribute(modelType, (Field)this.getAnnotatedElement(), changingOverTime);
            }
            return new PolicyAttributeModel((PolicyModel)modelType, (Method)this.getAnnotatedElement(), this.getSetterMethod(), this.isChangingOverTime());
        }

        private boolean isChangingOverTime() {
            boolean changingOverTime = false;
            if (this.getAnnotatedElement().isAnnotationPresent(IpsConfiguredAttribute.class)) {
                changingOverTime = this.getAnnotatedElement().getAnnotation(IpsConfiguredAttribute.class).changingOverTime();
            }
            return changingOverTime;
        }
    }
}

