/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.modeltype.IProductAssociationModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.ProductAssociationModel;
import org.faktorips.runtime.modeltype.internal.read.AbstractAssociationDescriptor;
import org.faktorips.runtime.modeltype.internal.read.AssociationCollector;

public class ProductAssociationModelCollector
extends AssociationCollector<IProductAssociationModel, ProductAssociationDescriptor> {
    public ProductAssociationModelCollector() {
        super(Arrays.asList(new ProductIpsAssociationProcessor()));
    }

    @Override
    protected ProductAssociationDescriptor createDescriptor() {
        return new ProductAssociationDescriptor();
    }

    static class ProductAssociationDescriptor
    extends AbstractAssociationDescriptor<IProductAssociationModel> {
        private boolean changingOverTime;

        ProductAssociationDescriptor() {
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }

        @Override
        protected IProductAssociationModel createValid(ModelType modelType) {
            return new ProductAssociationModel(modelType, this.getAnnotatedElement(), this.changingOverTime);
        }
    }

    static class ProductIpsAssociationProcessor
    extends AssociationCollector.IpsAssociationProcessor<ProductAssociationDescriptor> {
        ProductIpsAssociationProcessor() {
        }

        @Override
        public void process(ProductAssociationDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            super.process(descriptor, annotatedDeclaration, annotatedElement);
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
        }
    }
}

