/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.modeltype.IProductAttributeModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.ProductAttributeModel;
import org.faktorips.runtime.modeltype.internal.read.AbstractAttributeDescriptor;
import org.faktorips.runtime.modeltype.internal.read.AttributeCollector;

public class ProductAttributeModelCollector
extends AttributeCollector<IProductAttributeModel, ProductAttributeDescriptor> {
    public ProductAttributeModelCollector() {
        super(Arrays.asList(new ProductIpsAttributeProcessor(), new AttributeCollector.IpsAttributeSetterProcessor()));
    }

    @Override
    protected ProductAttributeDescriptor createDescriptor() {
        return new ProductAttributeDescriptor();
    }

    static class ProductAttributeDescriptor
    extends AbstractAttributeDescriptor<IProductAttributeModel> {
        private boolean changingOverTime;

        ProductAttributeDescriptor() {
        }

        @Override
        public IProductAttributeModel createValid(ModelType modelType) {
            return new ProductAttributeModel(modelType, this.isChangingOverTime(), (Method)this.getAnnotatedElement(), this.getSetterMethod());
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }
    }

    static class ProductIpsAttributeProcessor
    extends AttributeCollector.IpsAttributeProcessor<ProductAttributeDescriptor> {
        ProductIpsAttributeProcessor() {
        }

        @Override
        public void process(ProductAttributeDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
            descriptor.setAnnotatedElement(annotatedElement);
        }
    }
}

