/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.internal.read.SimpleGetterMethodCollector;
import org.faktorips.runtime.modeltype.internal.read.TypeModelPartsReader;

public class SimpleTypeModelPartsReader<E extends IModelElement, P extends Annotation, C extends Annotation> {
    private SimpleGetterMethodCollector<E, P, C> collector;
    private TypeModelPartsReader typeModelPartsReader;
    private Class<P> parentAnnotation;

    public SimpleTypeModelPartsReader(Class<P> parentAnnotation, NamesAccessor<P> namesAccessor, Class<C> childAnnotation, NameAccessor<C> nameAccessor, ModelElementCreator<E> modelElementCreator) {
        this.parentAnnotation = parentAnnotation;
        this.collector = new SimpleGetterMethodCollector<E, P, C>(parentAnnotation, namesAccessor, childAnnotation, nameAccessor, modelElementCreator);
        this.typeModelPartsReader = new TypeModelPartsReader(this.collector);
    }

    public LinkedHashMap<String, E> createParts(Class<?> annotatedClass, IModelElement parentModel) {
        return this.createParts(annotatedClass, annotatedClass, parentModel);
    }

    public LinkedHashMap<String, E> createParts(Class<?> classWithChildNameList, Class<?> classWithGetterMethods, IModelElement parentModel) {
        this.typeModelPartsReader.init(AnnotatedDeclaration.from(classWithChildNameList));
        this.readMethodsFromAnnotatedParentInterfaces(classWithGetterMethods);
        this.typeModelPartsReader.read(AnnotatedDeclaration.from(classWithGetterMethods));
        return this.collector.createParts(parentModel);
    }

    private void readMethodsFromAnnotatedParentInterfaces(Class<?> classWithGetterMethods) {
        if (classWithGetterMethods.isInterface()) {
            LinkedList superInterfaces = new LinkedList();
            Class<?> superInterfaceWithParentAnnotation = this.findSuperInterfaceWithParentAnnotation(classWithGetterMethods);
            while (superInterfaceWithParentAnnotation != null) {
                superInterfaces.push(superInterfaceWithParentAnnotation);
                superInterfaceWithParentAnnotation = this.findSuperInterfaceWithParentAnnotation(superInterfaceWithParentAnnotation);
            }
            while (!superInterfaces.isEmpty()) {
                this.typeModelPartsReader.read(AnnotatedDeclaration.from((Class)superInterfaces.pop()));
            }
        }
    }

    private Class<?> findSuperInterfaceWithParentAnnotation(Class<?> iface) {
        Class<?>[] classArray = iface.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            if (superInterface.isAnnotationPresent(this.parentAnnotation)) {
                return superInterface;
            }
            Class<?> interfaceWithAnnotation = this.findSuperInterfaceWithParentAnnotation(superInterface);
            if (interfaceWithAnnotation != null) {
                return interfaceWithAnnotation;
            }
            ++n2;
        }
        return null;
    }

    public static interface ModelElementCreator<T extends IModelElement> {
        public T create(IModelElement var1, String var2, Method var3);
    }

    public static interface NameAccessor<C extends Annotation> {
        public String getName(C var1);
    }

    public static interface NamesAccessor<A extends Annotation> {
        public String[] getNames(A var1);
    }
}

