/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.faktorips.runtime.model.annotation.IpsTableUsages;
import org.faktorips.runtime.modeltype.IModelElement;
import org.faktorips.runtime.modeltype.ITableUsageModel;
import org.faktorips.runtime.modeltype.internal.ModelType;
import org.faktorips.runtime.modeltype.internal.TableUsageModel;
import org.faktorips.runtime.modeltype.internal.read.AnnotationProcessor;
import org.faktorips.runtime.modeltype.internal.read.ModelPartCollector;
import org.faktorips.runtime.modeltype.internal.read.PartDescriptor;

public class TableUsageCollector
extends ModelPartCollector<ITableUsageModel, TableUsageDescriptor> {
    public TableUsageCollector() {
        super(Arrays.asList(new TableUsageProcessor()));
    }

    @Override
    protected TableUsageDescriptor createDescriptor() {
        return new TableUsageDescriptor();
    }

    @Override
    protected String[] getNames(AnnotatedDeclaration annotatedDeclaration) {
        if (annotatedDeclaration.is(IpsTableUsages.class)) {
            return annotatedDeclaration.get(IpsTableUsages.class).value();
        }
        return NO_NAMES;
    }

    static class TableUsageDescriptor
    extends PartDescriptor<ITableUsageModel> {
        private boolean changingOverTime;
        private Method annotatedElement;

        TableUsageDescriptor() {
        }

        public boolean isValid() {
            return this.getAnnotatedElement() != null;
        }

        public Method getAnnotatedElement() {
            return this.annotatedElement;
        }

        public void setAnnotatedElement(Method annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }

        @Override
        public ITableUsageModel create(IModelElement parentElement) {
            ModelType modelType = (ModelType)parentElement;
            if (this.isValid()) {
                return this.createValid(modelType);
            }
            throw new IllegalArgumentException(modelType.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsTableUsages but no matching @IpsTableUsage could be found.");
        }

        private TableUsageModel createValid(ModelType modelType) {
            return new TableUsageModel(modelType, this.getAnnotatedElement());
        }
    }

    static class TableUsageProcessor
    extends AnnotationProcessor<IpsTableUsage, TableUsageDescriptor> {
        public TableUsageProcessor() {
            super(IpsTableUsage.class);
        }

        @Override
        public String getName(IpsTableUsage annotation) {
            return annotation.name();
        }

        @Override
        public void process(TableUsageDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            descriptor.setAnnotatedElement((Method)annotatedElement);
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
        }
    }
}

