/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ProductCmptGenerationNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = -5796918674803530938L;
    private String repositoryName;
    private String productCmptId;
    private Calendar effectiveDate;
    private boolean productCmptWasFound;

    public ProductCmptGenerationNotFoundException(String repositoryName, String productCmptId, Calendar effectiveDate, boolean productCmptWasFound) {
        this.repositoryName = repositoryName;
        this.productCmptId = productCmptId;
        this.effectiveDate = effectiveDate;
        this.productCmptWasFound = productCmptWasFound;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getProductCmptId() {
        return this.productCmptId;
    }

    public Calendar getEffetiveDate() {
        return this.effectiveDate;
    }

    public boolean productCmptWasFound() {
        return this.productCmptWasFound;
    }

    @Override
    public String toString() {
        String date = SimpleDateFormat.getDateInstance(2).format(this.effectiveDate.getTime());
        String foundCmpt = this.productCmptWasFound ? "was found" : "was not found";
        return "ProductComponentGeneration " + this.productCmptId + " effective on " + date + " not found in repository, product component  " + foundCmpt + " in repository " + this.repositoryName;
    }
}

