/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.FormulaHandler;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProductComponent
extends RuntimeObject
implements IProductComponent,
IXmlPersistenceSupport {
    private static final String ATTRIBUTE_LOCALE = "locale";
    private static final String XML_ELEMENT_DESCRIPTION = "Description";
    private static final String IS_NULL = "isNull";
    private static final String VALID_FROM = "validFrom";
    private static final String VALID_TO = "validTo";
    private String id;
    private transient IRuntimeRepository repository;
    private String productKindId;
    private String versionId;
    private DateTime validFrom;
    private DateTime validTo;
    private final FormulaHandler formulaHandler;
    private InternationalString description;

    public ProductComponent(IRuntimeRepository repository, String id, String productKindId, String versionId) {
        if (repository == null) {
            throw new NullPointerException("RuntimeRepository was null!");
        }
        if (id == null) {
            throw new NullPointerException("Id was null!");
        }
        if (productKindId == null) {
            throw new NullPointerException("ProductKindId was null");
        }
        if (versionId == null) {
            throw new NullPointerException("VersionId was null");
        }
        this.repository = repository;
        this.id = id;
        this.productKindId = productKindId;
        this.versionId = versionId;
        this.formulaHandler = new FormulaHandler(this, this.repository);
    }

    @Override
    public String getKindId() {
        return this.productKindId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DateTime getValidFrom() {
        return this.validFrom;
    }

    @Override
    public Date getValidFrom(TimeZone zone) {
        return this.validFrom.toDate(zone);
    }

    public void setValidFrom(DateTime validfrom) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (validfrom == null) {
            throw new NullPointerException();
        }
        this.validFrom = validfrom;
    }

    @Override
    public DateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(DateTime validTo) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validTo = validTo;
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    @Override
    public IProductComponentGeneration getGenerationBase(Calendar effectiveDate) {
        if (!this.isChangingOverTime()) {
            throw new UnsupportedOperationException();
        }
        return this.getRepository().getProductComponentGeneration(this.id, effectiveDate);
    }

    @Override
    public IProductComponentGeneration getLatestProductComponentGeneration() {
        if (!this.isChangingOverTime()) {
            throw new UnsupportedOperationException();
        }
        return this.getRepository().getLatestProductComponentGeneration(this);
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaHandler.getFormulaEvaluator();
    }

    @Override
    public String getDescription(Locale locale) {
        String string = this.description.get(locale);
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public void initFromXml(Element cmptElement) {
        String validFromValue = cmptElement.getAttribute(VALID_FROM);
        this.validFrom = DateTime.parseIso(validFromValue);
        Element validToNode = (Element)cmptElement.getElementsByTagName(VALID_TO).item(0);
        this.validTo = validToNode == null || Boolean.parseBoolean(validToNode.getAttribute(IS_NULL)) ? null : DateTime.parseIso(validToNode.getTextContent());
        Map<String, Element> propertyElements = ProductComponentXmlUtil.getPropertyElements(cmptElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitTableUsagesFromXml(propertyElements);
        this.doInitFormulaFromXml(cmptElement);
        this.doInitReferencesFromXml(ProductComponentXmlUtil.getLinkElements(cmptElement));
        this.initExtensionPropertiesFromXml(cmptElement);
        this.initDescriptions(cmptElement);
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    protected void doInitTableUsagesFromXml(Map<String, Element> map) {
    }

    protected void doInitFormulaFromXml(Element element) {
        this.formulaHandler.doInitFormulaFromXml(element);
    }

    protected boolean isFormulaAvailable(String formularSignature) {
        return this.formulaHandler.isFormulaAvailable(formularSignature);
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> linkElements) {
    }

    private void initDescriptions(Element cmptElement) {
        List<Element> descriptionElements = XmlUtil.getElements(cmptElement, XML_ELEMENT_DESCRIPTION);
        ArrayList<LocalizedString> descriptions = new ArrayList<LocalizedString>(descriptionElements.size());
        for (Element descriptionElement : descriptionElements) {
            String localeCode = descriptionElement.getAttribute(ATTRIBUTE_LOCALE);
            Locale locale = "".equals(localeCode) ? null : new Locale(localeCode);
            String text = descriptionElement.getTextContent();
            descriptions.add(new LocalizedString(locale, text));
        }
        this.description = new DefaultInternationalString(descriptions, descriptions.isEmpty() ? null : ((LocalizedString)descriptions.get(0)).getLocale());
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Element toXml(Document document) {
        return this.toXml(document, true);
    }

    public Element toXml(Document document, boolean includeGenerations) {
        Element prodCmptElement = document.createElement("ProductComponent");
        this.writeValidFromToXml(prodCmptElement);
        this.writeValidToToXml(prodCmptElement);
        this.writePropertiesToXml(prodCmptElement);
        this.writeTableUsagesToXml(prodCmptElement);
        this.writeFormulaToXml(prodCmptElement);
        this.writeReferencesToXml(prodCmptElement);
        this.writeExtensionPropertiesToXml(prodCmptElement);
        this.writeDescriptionToXml(prodCmptElement);
        if (includeGenerations) {
            List<IProductComponentGeneration> generations = this.getRepository().getProductComponentGenerations(this);
            for (IProductComponentGeneration generation : generations) {
                ProductComponentGeneration gen = (ProductComponentGeneration)generation;
                prodCmptElement.appendChild(gen.toXml(document));
            }
        }
        return prodCmptElement;
    }

    private void writeValidFromToXml(Element prodCmptElement) {
        if (this.validFrom != null) {
            prodCmptElement.setAttribute(VALID_FROM, this.validFrom.toIsoFormat());
        }
    }

    private void writeValidToToXml(Element prodCmptElement) {
        Element validToElement = prodCmptElement.getOwnerDocument().createElement(VALID_TO);
        if (this.validTo != null) {
            validToElement.setAttribute(IS_NULL, Boolean.FALSE.toString());
            validToElement.setTextContent(this.validTo.toIsoFormat());
            prodCmptElement.appendChild(validToElement);
        } else {
            validToElement.setAttribute(IS_NULL, Boolean.TRUE.toString());
        }
    }

    protected void writePropertiesToXml(Element element) {
        throw new UnsupportedOperationException("The method toXml() is currently not supported, as the required methods were not generated. To activate toXml() please check your FIPS Builder properties and make sure \"Generated toXml Support\" is set to true.");
    }

    protected void writeTableUsagesToXml(Element element) {
    }

    protected void writeTableUsageToXml(Element element, String structureUsage, String tableContentName) {
        ValueToXmlHelper.addTableUsageToElement(element, structureUsage, tableContentName);
    }

    private void writeDescriptionToXml(Element prodCmptElement) {
        if (this.description != null) {
            for (LocalizedString localizedString : ((DefaultInternationalString)this.description).getLocalizedStrings()) {
                Element descriptionElement = prodCmptElement.getOwnerDocument().createElement(XML_ELEMENT_DESCRIPTION);
                descriptionElement.setAttribute(ATTRIBUTE_LOCALE, localizedString.getLocale().toString());
                descriptionElement.setTextContent(localizedString.getValue());
                prodCmptElement.appendChild(descriptionElement);
            }
        }
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        return null;
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        return new ArrayList<IProductComponentLink<? extends IProductComponent>>();
    }

    protected void writeReferencesToXml(Element element) {
    }

    protected void writeFormulaToXml(Element element) {
        this.formulaHandler.writeFormulaToXml(element);
    }
}

