/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model;

import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.AbstractComputable;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsPolicyCmptType;
import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class IpsModel {
    private static final Memoizer<Class<? extends ITable>, TableStructure> TABLE_MODEL_CACHE = new Memoizer<Class<? extends ITable>, TableStructure>(new AbstractComputable<Class<? extends ITable>, TableStructure>(TableStructure.class){

        @Override
        public TableStructure compute(Class<? extends ITable> tableObjectClass) {
            if (tableObjectClass.isAnnotationPresent(IpsTableStructure.class)) {
                return new TableStructure(tableObjectClass);
            }
            throw new IllegalArgumentException("The class " + tableObjectClass.getName() + "is not annotated as IpsTableStructure.");
        }
    });
    private static final Memoizer<Class<?>, EnumType> ENUM_MODEL_CACHE = new Memoizer(new AbstractComputable<Class<?>, EnumType>(EnumType.class){

        @Override
        public EnumType compute(Class<?> enumObjectClass) {
            if (enumObjectClass.isAnnotationPresent(IpsEnumType.class)) {
                return new EnumType(enumObjectClass);
            }
            throw new IllegalArgumentException("The class " + enumObjectClass.getName() + " is not annotated as IpsEnumType.");
        }
    });
    private static final Memoizer<AnnotatedDeclaration, ProductCmptType> PRODUCT_MODEL_CACHE = new Memoizer<AnnotatedDeclaration, ProductCmptType>(new AbstractComputable<AnnotatedDeclaration, ProductCmptType>(ProductCmptType.class){

        @Override
        public ProductCmptType compute(AnnotatedDeclaration annotatedDeclaration) {
            if (annotatedDeclaration.is(IpsProductCmptType.class)) {
                String name = annotatedDeclaration.get(IpsProductCmptType.class).name();
                return new ProductCmptType(name, annotatedDeclaration);
            }
            throw new IllegalArgumentException("The class " + annotatedDeclaration.getDeclarationClassName() + " is not annotated as product component type.");
        }
    });
    private static final Memoizer<AnnotatedDeclaration, PolicyCmptType> POLICY_MODEL_CACHE = new Memoizer<AnnotatedDeclaration, PolicyCmptType>(new AbstractComputable<AnnotatedDeclaration, PolicyCmptType>(PolicyCmptType.class){

        @Override
        public PolicyCmptType compute(AnnotatedDeclaration annotatedModelType) {
            if (annotatedModelType.is(IpsPolicyCmptType.class)) {
                String name = annotatedModelType.get(IpsPolicyCmptType.class).name();
                return new PolicyCmptType(name, annotatedModelType);
            }
            throw new IllegalArgumentException("The class " + annotatedModelType.getDeclarationClassName() + " is not annotated as policy component type.");
        }
    });

    private IpsModel() {
    }

    private static <K, V> V get(Memoizer<K, V> memoizer, K key) {
        try {
            return memoizer.compute(key);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static TableStructure getTableStructure(Class<? extends ITable> tableObjectClass) {
        return IpsModel.get(TABLE_MODEL_CACHE, tableObjectClass);
    }

    public static TableStructure getTableStructure(ITable table) {
        return IpsModel.getTableStructure(table.getClass());
    }

    public static boolean isProductCmptType(Class<?> productModelClass) {
        return AnnotatedDeclaration.from(productModelClass).is(IpsProductCmptType.class);
    }

    public static ProductCmptType getProductCmptType(Class<? extends IProductComponent> productModelClass) {
        return IpsModel.get(PRODUCT_MODEL_CACHE, AnnotatedDeclaration.from(productModelClass));
    }

    public static ProductCmptType getProductCmptType(IProductComponent productComponent) {
        return IpsModel.getProductCmptType(productComponent.getClass());
    }

    public static boolean isPolicyCmptType(Class<?> policyModelClass) {
        return AnnotatedDeclaration.from(policyModelClass).is(IpsPolicyCmptType.class);
    }

    public static PolicyCmptType getPolicyCmptType(Class<? extends IModelObject> policyModelClass) {
        return IpsModel.get(POLICY_MODEL_CACHE, AnnotatedDeclaration.from(policyModelClass));
    }

    public static PolicyCmptType getPolicyCmptType(IModelObject modelObject) {
        return IpsModel.getPolicyCmptType(modelObject.getClass());
    }

    public static Type getType(Class<?> modelObjectClass) {
        AnnotatedDeclaration annotatedModelType = AnnotatedDeclaration.from(modelObjectClass);
        if (annotatedModelType.is(IpsProductCmptType.class)) {
            return IpsModel.getProductCmptType(modelObjectClass.asSubclass(IProductComponent.class));
        }
        if (annotatedModelType.is(IpsPolicyCmptType.class)) {
            return IpsModel.getPolicyCmptType(modelObjectClass.asSubclass(IModelObject.class));
        }
        throw new IllegalArgumentException("The given " + modelObjectClass + " is not annotated as product or policy component type.");
    }

    public static EnumType getEnumType(Class<?> enumObjectClass) {
        return IpsModel.get(ENUM_MODEL_CACHE, enumObjectClass);
    }

    public static EnumType getEnumType(Object enumInstance) {
        if (enumInstance instanceof Enum) {
            return IpsModel.getEnumType(((Enum)enumInstance).getDeclaringClass());
        }
        return IpsModel.getEnumType(enumInstance.getClass());
    }
}

