/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.GenerationId;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.AbstractComputable;
import org.faktorips.runtime.caching.IComputable;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;

public abstract class AbstractCachingRuntimeRepository
extends AbstractRuntimeRepository {
    private ICacheFactory cacheFactory;
    private volatile IComputable<String, IProductComponent> productCmptCache;
    private volatile IComputable<GenerationId, IProductComponentGeneration> productCmptGenerationCache;
    private volatile IComputable<String, ITable> tableCacheByQName;
    private volatile IComputable<Class<?>, List<?>> enumValuesCacheByClass;
    private List<XmlAdapter<?, ?>> enumXmlAdapters;
    private volatile Map<Class<?>, IComputable<String, Object>> customRuntimeObjectsByTypeCache = new HashMap();

    public AbstractCachingRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name);
        this.cacheFactory = cacheFactory;
        this.initCaches(cl);
    }

    protected void initCaches(ClassLoader cl) {
        try {
            Class<?> productCmptClass = cl.loadClass(IProductComponent.class.getName());
            AbstractComputable<String, IProductComponent> productCmptComputer = new AbstractComputable<String, IProductComponent>(productCmptClass){

                @Override
                public IProductComponent compute(String key) throws InterruptedException {
                    return AbstractCachingRuntimeRepository.this.getNotCachedProductComponent(key);
                }
            };
            this.productCmptCache = this.cacheFactory.createProductCmptCache((IComputable<String, IProductComponent>)productCmptComputer);
            Class<?> productCmptGenClass = cl.loadClass(IProductComponentGeneration.class.getName());
            AbstractComputable<GenerationId, IProductComponentGeneration> productCmptGenComputer = new AbstractComputable<GenerationId, IProductComponentGeneration>(productCmptGenClass){

                @Override
                public IProductComponentGeneration compute(GenerationId key) throws InterruptedException {
                    return AbstractCachingRuntimeRepository.this.getNotCachedProductComponentGeneration(key);
                }
            };
            this.productCmptGenerationCache = this.cacheFactory.createProductCmptGenerationCache((IComputable<GenerationId, IProductComponentGeneration>)productCmptGenComputer);
            Class<?> tableClass = cl.loadClass(ITable.class.getName());
            AbstractComputable<String, ITable> tableComputer = new AbstractComputable<String, ITable>(tableClass){

                @Override
                public ITable compute(String key) throws InterruptedException {
                    return AbstractCachingRuntimeRepository.this.getNotCachedTable(key);
                }
            };
            this.tableCacheByQName = this.cacheFactory.createTableCache((IComputable<String, ITable>)tableComputer);
            AbstractComputable enumValueComputer = new AbstractComputable<Class<?>, List<?>>(List.class){

                @Override
                public List<?> compute(Class<?> key) throws InterruptedException {
                    return AbstractCachingRuntimeRepository.this.getNotCachedEnumValues(key);
                }
            };
            this.enumValuesCacheByClass = this.cacheFactory.createEnumCache(enumValueComputer);
            this.enumXmlAdapters = new ArrayList();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IProductComponent getProductComponentInternal(String id) {
        try {
            return this.productCmptCache.compute(id);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract IProductComponent getNotCachedProductComponent(String var1);

    protected IProductComponentGeneration getProductComponentGenerationInternal(String id, DateTime validFrom) {
        GenerationId generationId = new GenerationId(id, validFrom);
        try {
            return this.productCmptGenerationCache.compute(generationId);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract IProductComponentGeneration getNotCachedProductComponentGeneration(GenerationId var1);

    @Override
    protected <T> List<T> getEnumValuesInternal(Class<T> clazz) {
        try {
            List<?> result = this.enumValuesCacheByClass.compute(clazz);
            return result;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract <T> List<T> getNotCachedEnumValues(Class<T> var1);

    @Override
    protected ITable getTableInternal(String qualifiedTableName) {
        try {
            return this.tableCacheByQName.compute(qualifiedTableName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract ITable getNotCachedTable(String var1);

    @Override
    protected List<XmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository repository) {
        if (!this.enumXmlAdapters.isEmpty()) {
            return this.enumXmlAdapters;
        }
        this.enumXmlAdapters = this.getNotCachedEnumXmlAdapter(repository);
        return this.enumXmlAdapters;
    }

    protected abstract List<XmlAdapter<?, ?>> getNotCachedEnumXmlAdapter(IRuntimeRepository var1);

    @Override
    protected <T> T getCustomRuntimeObjectInternal(Class<T> type, String ipsObjectQualifiedName) {
        try {
            IComputable<String, T> cache = this.getCache(type);
            return cache.compute(ipsObjectQualifiedName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> IComputable<String, T> getCache(Class<T> type) {
        IComputable<String, Object> cache = this.customRuntimeObjectsByTypeCache.get(type);
        if (cache == null) {
            IComputable<String, Object> cache2 = cache = this.initCache(type);
            this.customRuntimeObjectsByTypeCache.put(type, cache2);
        }
        return cache;
    }

    private <T> IComputable<String, T> initCache(final Class<T> type) {
        AbstractComputable computer = new AbstractComputable<String, T>(type){

            @Override
            public T compute(String key) throws InterruptedException {
                return AbstractCachingRuntimeRepository.this.getNotCachedCustomObject(type, key);
            }
        };
        IComputable cache = this.cacheFactory.createCache(computer);
        return cache;
    }

    protected abstract <T> T getNotCachedCustomObject(Class<T> var1, String var2);
}

