/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.util.ArrayList;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;

public class JAXBContextFactory {
    private JAXBContextFactory() {
    }

    public static JAXBContext newContext(IRuntimeRepository repository) throws JAXBException, ClassNotFoundException {
        ClassLoader cl = repository.getClass().getClassLoader();
        if (repository instanceof AbstractRuntimeRepository) {
            cl = ((AbstractRuntimeRepository)repository).getClassLoader();
        }
        return JAXBContextFactory.newContext(repository, cl);
    }

    public static JAXBContext newContext(IRuntimeRepository repository, ClassLoader cl) throws JAXBException, ClassNotFoundException {
        Set<String> classNames = repository.getAllModelTypeImplementationClasses();
        ArrayList classes = new ArrayList(classNames.size());
        for (String className : classNames) {
            Class<?> clazz = cl.loadClass(className);
            if (!AbstractModelObject.class.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
    }
}

