/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.TableSaxHandler;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Table<T>
implements ITable {
    private String name;
    protected List<T> rows;

    protected abstract void addRow(List<String> var1, IRuntimeRepository var2);

    protected abstract void initKeyMaps();

    public void initFromXml(InputStream is, IRuntimeRepository productRepository, String qualifiedTableName) throws Exception {
        this.rows = new ArrayList<T>(200);
        this.name = qualifiedTableName;
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse(new InputSource(is), (DefaultHandler)new TableSaxHandler(this, productRepository));
        ((ArrayList)this.rows).trimToSize();
        this.init();
    }

    protected void init() {
        this.initKeyMaps();
        this.performAdditionalInitializations();
    }

    protected void performAdditionalInitializations() {
    }

    protected boolean isNull(Element valueElement) {
        return Boolean.valueOf(valueElement.getAttribute("isNull"));
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        Iterator<T> it = this.rows.iterator();
        int i = 0;
        while (it.hasNext() && i < 10) {
            if (i != 0) {
                output.append("\n");
            }
            output.append(it.next().toString());
            ++i;
        }
        return output.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

